/*
 * Decompiled with CFR 0.152.
 */
package dexter.utils;

import dexter.DynamicParser;
import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.Graph;
import dexter.parser.Item;
import dexter.parser.LookaheadSet;
import dexter.parser.ParserState;
import dexter.utils.NoSuchTransitionException;
import java.util.ArrayList;
import java.util.Iterator;

public class Graphviz {
    DynamicParser p;

    public Graphviz(DynamicParser dp) {
        this.p = dp;
    }

    private String escape(String in) {
        return in.replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("{", "&#123;").replace("}", "&#125;");
    }

    public String stateString(ParserState state, boolean lookahead) {
        String fillcolor = state.isInvalid() ? " fillcolor = \"red\" " : " fillcolor = \"white\" ";
        String s = "I" + state.getId() + "[ style = \"filled\" penwidth = 1 fontname = \"Courier New\" shape = \"Mrecord\" fontsize = \"10\"," + fillcolor + " label =<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\"><tr><td bgcolor=\"black\" align=\"center\" colspan=\"3\"><font color=\"white\">State #" + state.getId() + "</font></td></tr>";
        int count = 0;
        ArrayList<Item> sortedKernel = new ArrayList<Item>(state.kernel);
        for (Item i : sortedKernel) {
            String itemString = this.itemString(i);
            s = s + "<tr><td align=\"left\" port=\"r0\">&#40;" + count++ + "&#41;</td><td align=\"left\">" + this.escape(itemString) + "</td>";
            if (lookahead && i.isCandidate()) {
                s = s + this.lookaheadString(state.kernel.getLookahead(i));
            }
            s = s + "</tr>";
        }
        String field = "<tr><td align=\"left\" port=\"r0\">&#40;%d&#41;</td><td align=\"left\"><font color=\"#777777\">%s</font></td></tr>";
        ArrayList<Item> closureList = new ArrayList<Item>();
        closureList.addAll(sortedKernel);
        for (int i = 0; i < closureList.size(); ++i) {
            Item item = (Item)closureList.get(i);
            if (item.isCandidate()) continue;
            if (item.getSymbolAtPos() instanceof NonTerminalSym) {
                for (Production nonk : this.p.grammar.getProductions((NonTerminalSym)item.getSymbolAtPos())) {
                    Item nextItem = nonk.toItem();
                    if (closureList.contains(nextItem)) continue;
                    closureList.add(nonk.toItem());
                }
            }
            if (item.isKernel()) continue;
            s = s + String.format("<tr><td align=\"left\" port=\"r0\">&#40;%d&#41;</td><td align=\"left\"><font color=\"#777777\">%s</font></td></tr>", count++, this.itemString(item));
        }
        s = s + "</table>> ];\n";
        return s;
    }

    private String lookaheadString(LookaheadSet lookahead) {
        String out = "";
        for (TerminalSym s : lookahead) {
            out = out + this.escape(s.toString()) + " ";
        }
        return "<td bgcolor=\"grey\" align=\"right\">" + out + "</td>";
    }

    public String itemString(Item itm) {
        String s = itm.nt.toString() + " \u2192 ";
        Iterator iter = itm.body.iterator();
        for (int i = 0; i < itm.body.size(); ++i) {
            if (i == itm.pos) {
                s = s + "&bull;";
            }
            Symbol sym = (Symbol)iter.next();
            s = s + (sym instanceof TerminalSym ? "'" + this.escape(sym.toString()) + "'" : this.escape(sym.toString())) + " ";
        }
        if (itm.isCandidate()) {
            s = s + "&bull;";
        }
        return s;
    }

    private String htmlSanitize(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
    }

    public String graphString(final boolean lookahead) {
        Graph graph = this.p.graph;
        Grammar grammar = this.p.grammar;
        String out = "digraph graph" + graph.getUpdateCount() + " {\n";
        out = out + " graph [fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\"];\n  ratio = auto;\n";
        out = out + "\n";
        out = out + this.grammarString(grammar);
        Graph.Visitor v = new Graph.Visitor(){
            String str = "";

            @Override
            public void visit(ParserState s) {
                this.str = this.str + Graphviz.this.stateString(s, lookahead);
                try {
                    for (NonTerminalSym nonTerminalSym : s.goTo.getNonTerminaSymbols()) {
                        this.str = this.str + String.format("I%d -> I%d [label = \"%s\"];\n", s.getId(), s.goTo.getTransition(nonTerminalSym).getId(), nonTerminalSym);
                    }
                    for (Symbol symbol : s.goTo.getTerminalSymbols()) {
                        this.str = this.str + String.format("I%d -> I%d [label = \"'%s'\"];\n", s.getId(), s.goTo.getTransition(symbol).getId(), symbol);
                    }
                }
                catch (NoSuchTransitionException noSuchTransitionException) {
                    // empty catch block
                }
            }

            public String toString() {
                return this.str;
            }
        };
        graph.breadthFirstVisit(v);
        out = out + this.stateString(graph, false);
        out = out + v.toString() + "\n}";
        return out;
    }

    private String grammarString(Grammar g) {
        String s = "Grammar [ style = \"filled\" penwidth = 1 fillcolor = \"white\" fontname = \"Courier New\" shape = \"Mrecord\" , label =<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\"><tr><td bgcolor=\"black\" align=\"center\" colspan=\"2\"><font color=\"white\">Grammar</font></td></tr>";
        for (Production p : g.getProductions()) {
            s = s + "<tr><td align=\"left\">" + this.escape(p.toString()) + "</td></tr>\\n";
        }
        return s + "</table>> ];";
    }
}

