/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser.ast;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import java.io.Serializable;
import java.util.HashMap;

public class ASTNode
implements Serializable,
Symbol {
    protected Symbol symbol;
    protected Production rule;
    public ASTNode[] children = new ASTNode[0];
    protected HashMap<String, Object> map = new HashMap();
    static int id;
    protected int _id;
    private ASTNode[] ntchildren;

    public ASTNode(Symbol s) {
        this.symbol = s;
        this._id = id++;
    }

    public ASTNode(Production r) {
        this(r.nt);
        this.rule = r;
        this.children = new ASTNode[this.rule.body.size()];
    }

    ASTNode[] getNonterminalChildren() {
        int count = 0;
        for (Symbol s : this.rule.body) {
            if (!(s instanceof NonTerminalSym)) continue;
            ++count;
        }
        ASTNode[] ntc = new ASTNode[count];
        count = 0;
        for (int i = 0; i < this.rule.body.size(); ++i) {
            Symbol s = (Symbol)this.rule.body.get(i);
            if (!(s instanceof NonTerminalSym)) continue;
            ntc[count] = this.children[i];
            ++count;
        }
        return ntc;
    }

    public Production getProduction() {
        return this.rule;
    }

    public int getId() {
        return this._id;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public <T extends Symbol> T getSymbol() {
        return (T)this.symbol;
    }

    public void addChild(ASTNode node) {
        int i = 0;
        while (this.children[i] != null) {
            ++i;
        }
        this.children[i] = node;
    }

    public ASTNode[] getChildren() {
        return this.children;
    }

    public ASTNode getChild(int i) {
        return this.children[i];
    }

    public ASTNode[] children() {
        return this.children;
    }

    public ASTNode child(int i) {
        try {
            return this.children[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setChild(int i, ASTNode n) {
        this.children[i] = n;
    }

    public ASTNode ntchild(int i) {
        try {
            return this.ntchildren[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String toString() {
        String s = this.symbol.toString() + "(";
        if (this.children == null) {
            return s + ")";
        }
        for (int i = 0; i < this.children.length - 1; ++i) {
            s = s + this.children[i] + ", ";
        }
        return s + this.children[this.children.length - 1] + ")";
    }

    public String toFlattenedString() {
        if (this.symbol != null && this.symbol instanceof TerminalSym) {
            return this.symbol.toString();
        }
        String s = "(";
        for (ASTNode n : this.children) {
            s = s + n.toFlattenedString();
        }
        s = s + ")";
        return s;
    }

    public <T> void setValue(String name, T value) {
        this.map.put(name, value);
    }

    public <T> T getValue(String name) {
        if (this.map.containsKey(name)) {
            return (T)this.map.get(name);
        }
        throw new RuntimeException("Undefined attribute:" + name);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ASTNode && that.hashCode() == this.hashCode();
    }

    @Override
    public int hashCode() {
        return this.symbol.hashCode();
    }

    void setNTChildren(ASTNode[] nonterminalChildren) {
        this.ntchildren = nonterminalChildren;
    }
}

