/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser;

import dexter.grammar.Grammar;
import dexter.grammar.IProductionBody;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Item
extends Production {
    public final int pos;

    @Override
    public int hashCode() {
        int prime = 3;
        return super.hashCode() + this.pos;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isPrefix(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        return this.nt.equals(other.nt) && this.body.subList(0, this.pos).equals(other.body.subList(0, this.pos));
    }

    public Item(Production p, int pos) {
        super(p.nt, p.body);
        this.pos = pos;
        this.setLabel(p.getLabel());
        this.setScore(p.getScore());
        this.setRightAssociative(p.isRightAssociative());
    }

    public Item(NonTerminalSym nt, IProductionBody body, int pos) {
        super(nt, body);
        this.pos = pos;
    }

    public Symbol getSymbolAtPos() {
        return this.pos < this.body.size() ? (Symbol)this.body.get(this.pos) : null;
    }

    @Override
    public String toString() {
        String s = this.nt.toString() + "->";
        Iterator iter = this.body.iterator();
        for (int i = 0; i < this.body.size(); ++i) {
            if (i == this.pos) {
                s = s + "\u2022";
            }
            s = s + " " + ((Symbol)iter.next()).toString();
        }
        if (this.pos == this.body.size()) {
            s = s + "\u2022";
        }
        return s;
    }

    public Item next() {
        Item i = new Item(this.nt, this.body, this.pos + 1);
        i.setLabel(this.getLabel());
        i.setRightAssociative(this.isRightAssociative());
        i.setScore(this.getScore());
        return i;
    }

    public Item prev() {
        Item i = new Item(this.nt, this.body, this.pos - 1);
        i.setLabel(this.getLabel());
        i.setRightAssociative(this.isRightAssociative());
        i.setScore(this.getScore());
        return i;
    }

    public boolean productionEquals(Production that) {
        return this.nt.equals(that.nt) && this.body.equals(that.body);
    }

    public Production toProduction() {
        Production p = new Production(this.nt, this.body);
        p.setLabel(this.getLabel());
        p.setScore(this.getScore());
        p.setRightAssociative(this.isRightAssociative());
        return p;
    }

    public boolean isKernel() {
        return this.pos > 0 || Grammar.START.equals(this.nt);
    }

    public boolean isCandidate() {
        return null == this.getSymbolAtPos();
    }

    public List<Symbol> rest() {
        return new ArrayList<Symbol>(this.body.subList(this.pos + 1, this.body.size()));
    }
}

