/*
 * Decompiled with CFR 0.152.
 */
package dexter.grammar;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.Productions;
import dexter.grammar.Symbol;
import dexter.grammar.SymbolSet;
import dexter.grammar.TerminalSym;
import java.io.Serializable;
import java.util.Collection;

public class NullableSymbolSet
implements Serializable {
    private SymbolSet<NonTerminalSym> nullables = new SymbolSet();
    private Grammar g;

    public NullableSymbolSet(Grammar g) {
        this.g = g;
    }

    public boolean isNullable(Collection<Symbol> list) {
        for (Symbol s : list) {
            if (this.isNullable(s)) continue;
            return false;
        }
        return true;
    }

    public boolean isNullable(Symbol s) {
        if (s instanceof TerminalSym) {
            return s.equals(Grammar.EPSILON);
        }
        return this.nullables.contains(s);
    }

    public void update(Production p) {
        if (this.nullables.contains(p.nt)) {
            return;
        }
        if (Productions.isEpsilon(p)) {
            this.nullables.add(p.nt);
        } else {
            if (Productions.hasTerminals(p)) {
                return;
            }
            for (Symbol s : p.body) {
                if (this.isNullable(s)) continue;
                return;
            }
        }
        this.nullables.add(p.nt);
        SymbolSet newSymbols = new SymbolSet(this.g.reverseLookup.get(p.nt));
        while (newSymbols.hasMore()) {
            NonTerminalSym sym = (NonTerminalSym)newSymbols.visitNext();
            this.nullables.add(sym);
            newSymbols.addAll(this.g.reverseLookup.get(sym));
        }
    }

    public String toString() {
        return this.nullables.toString();
    }
}

