/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.examples;

import java.util.List;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.IFilter;
import org.paukov.combinatorics.IntegerFactory;
import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;
import org.paukov.combinatorics.util.ComplexCombinationGenerator;

public class Main {
    public static void main(String[] stringArray) {
        Main.permutationWithoutRepetitions();
        Main.permutationWithRepetitions();
        Main.simpleCombinations();
        Main.multiCombinations();
        Main.simpleSubSets();
        Main.duplicateSubSets();
        Main.integerPartition();
        Main.integerComposition();
        Main.complexCombinationIndexesExample();
        Main.complexCombinationExample();
        Main.simpleWithEqualElementsPermutation();
        Main.simpleFiveIntegerCompositionRange();
        Main.filteredCombinations();
    }

    static void simpleCombinations() {
        System.out.println("simpleCombinations");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"red", "black", "white", "green", "blue"});
        Generator<String> generator = Factory.createSimpleCombinationGenerator(iCombinatoricsVector, 3);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void multiCombinations() {
        System.out.println("multiCombinations");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"apple", "orange"});
        Generator<String> generator = Factory.createMultiCombinationGenerator(iCombinatoricsVector, 3);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void permutationWithRepetitions() {
        System.out.println("permutationWithRepetitions");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"apple", "orange"});
        Generator<String> generator = Factory.createPermutationWithRepetitionGenerator(iCombinatoricsVector, 3);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void permutationWithoutRepetitions() {
        System.out.println("permutationWithoutRepetitions");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"apple", "orange", "cherry"});
        Generator<String> generator = Factory.createPermutationGenerator(iCombinatoricsVector);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void complexCombinationIndexesExample() {
        System.out.println("complexCombinationIndexesExample");
        String[] stringArray = new String[]{"A", "B", "B", "C"};
        ICombinatoricsVector<Integer> iCombinatoricsVector = Factory.createVector(new Integer[]{1, 1, 3});
        ComplexCombinationGenerator<Integer> complexCombinationGenerator = new ComplexCombinationGenerator<Integer>(iCombinatoricsVector, 2);
        for (ICombinatoricsVector iCombinatoricsVector2 : complexCombinationGenerator) {
            String string = ComplexCombinationGenerator.convertIndexes2String(stringArray, iCombinatoricsVector2);
            System.out.println(string);
        }
    }

    static void complexCombinationExample() {
        System.out.println("complexCombinationExample");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"A", "B", "B", "C"});
        ComplexCombinationGenerator<String> complexCombinationGenerator = new ComplexCombinationGenerator<String>(iCombinatoricsVector, 2);
        for (ICombinatoricsVector iCombinatoricsVector2 : complexCombinationGenerator) {
            System.out.println(ComplexCombinationGenerator.convert2String(iCombinatoricsVector2) + " - " + iCombinatoricsVector2);
        }
    }

    static void simpleSubSets() {
        System.out.println("simpleSubSets");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"one", "two", "three"});
        Generator<String> generator = Factory.createSubSetGenerator(iCombinatoricsVector);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void duplicateSubSets() {
        System.out.println("duplicateSubSets");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"a", "b", "a", "c"});
        Generator<String> generator = Factory.createSubSetGenerator(iCombinatoricsVector, false);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void integerPartition() {
        System.out.println("integerPartition");
        Generator<Integer> generator = Factory.createPartitionGenerator(5);
        for (ICombinatoricsVector iCombinatoricsVector : generator) {
            System.out.println(iCombinatoricsVector);
        }
    }

    static void integerComposition() {
        System.out.println("integerComposition");
        Generator<Integer> generator = Factory.createCompositionGenerator(5);
        for (ICombinatoricsVector iCombinatoricsVector : generator) {
            System.out.println(iCombinatoricsVector);
        }
    }

    static void simpleWithEqualElementsPermutation() {
        System.out.println("simpleWithEqualElementsPermutation");
        ICombinatoricsVector<Integer> iCombinatoricsVector = Factory.createVector(new Integer[]{1, 1, 2, 2});
        Generator<Integer> generator = Factory.createPermutationGenerator(iCombinatoricsVector);
        for (ICombinatoricsVector iCombinatoricsVector2 : generator) {
            System.out.println(iCombinatoricsVector2);
        }
    }

    static void simpleFiveIntegerCompositionRange() {
        System.out.println("simpleFiveIntegerCompositionRange");
        IntegerGenerator integerGenerator = IntegerFactory.createIntegerCompositionGenerator(5);
        List<IntegerVector> list = integerGenerator.generateObjectsRange(5, 7);
        for (IntegerVector integerVector : list) {
            System.out.println(integerVector);
        }
    }

    static void filteredCombinations() {
        System.out.println("filteredCombinations");
        ICombinatoricsVector<String> iCombinatoricsVector = Factory.createVector(new String[]{"apple", "orange", "cherry", "melon"});
        Generator<String> generator = Factory.createSimpleCombinationGenerator(iCombinatoricsVector, 3);
        List<ICombinatoricsVector<String>> list = generator.generateFilteredObjects(new IFilter<ICombinatoricsVector<String>>(){

            @Override
            public boolean accepted(long l, ICombinatoricsVector<String> iCombinatoricsVector) {
                return iCombinatoricsVector.contains("orange");
            }
        });
        for (ICombinatoricsVector<String> iCombinatoricsVector2 : list) {
            System.out.println(iCombinatoricsVector2);
        }
    }
}

