/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.permutations;

import java.util.ArrayList;
import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.permutations.PermutationWithRepetitionGenerator;

public class PermutationWithRepetitionIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final PermutationWithRepetitionGenerator<T> _generator;
    protected ICombinatoricsVector<T> _currentPermutation = null;
    protected long _currentIndex = 0L;
    protected final int _n;
    protected final int _k;
    private int[] _bitVector = null;

    public PermutationWithRepetitionIterator(PermutationWithRepetitionGenerator<T> permutationWithRepetitionGenerator) {
        this._generator = permutationWithRepetitionGenerator;
        this._n = permutationWithRepetitionGenerator.getOriginalVector().getSize();
        this._k = permutationWithRepetitionGenerator.getPermutationLength();
        ArrayList arrayList = new ArrayList(this._k);
        Object t = permutationWithRepetitionGenerator.getOriginalVector().getValue(0);
        for (int i = 0; i < this._k; ++i) {
            arrayList.add(t);
        }
        this._currentPermutation = Factory.createVector(arrayList);
        this._bitVector = new int[this._k + 2];
        this.init();
    }

    private void init() {
        for (int i = 0; i <= this._k; ++i) {
            this._bitVector[i] = 0;
        }
        this._currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this._bitVector[this._k] != 1;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        int n;
        ++this._currentIndex;
        for (n = this._k - 1; n >= 0; --n) {
            int n2 = this._bitVector[n];
            this._currentPermutation.setValue(n, this._generator.getOriginalVector().getValue(n2));
        }
        n = 0;
        while (this._bitVector[n] == this._n - 1) {
            if (n >= this._k + 1) {
                this._bitVector[this._k] = 1;
                return Factory.createVector(this._currentPermutation);
            }
            this._bitVector[n] = 0;
            ++n;
        }
        int n3 = n;
        this._bitVector[n3] = this._bitVector[n3] + 1;
        return Factory.createVector(this._currentPermutation);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "PermutationWithRepetitionIterator=[#" + this._currentIndex + ", " + this._currentPermutation + "]";
    }
}

