/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.permutations;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;

public class PermutationIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final Generator<T> _generator;
    protected ICombinatoricsVector<T> _currentPermutation;
    protected long _currentIndex = 0L;
    protected final int _length;
    private int[] _pZ = null;
    private int[] _pP = null;
    private int[] _pD = null;
    private int m = 0;
    private int w = 0;
    private int pm = 0;
    private int dm = 0;
    private int zpm = 0;

    public PermutationIterator(Generator<T> generator) {
        this._generator = generator;
        this._length = ((ICombinatoricsVector)generator.getOriginalVector()).getSize();
        this._currentPermutation = Factory.createVector((ICombinatoricsVector)generator.getOriginalVector());
        this._pZ = new int[this._length + 2];
        this._pP = new int[this._length + 2];
        this._pD = new int[this._length + 2];
        this.init();
    }

    private void init() {
        this._currentIndex = 0L;
        this.m = 0;
        this.w = 0;
        this.pm = 0;
        this.dm = 0;
        this.zpm = 0;
        for (int i = 1; i <= this._length; ++i) {
            this._pP[i] = i;
            this._pZ[i] = i;
            this._pD[i] = -1;
        }
        this._pD[1] = 0;
        this._pZ[this._length + 1] = this.m = this._length + 1;
        this._pZ[0] = this._pZ[this._length + 1];
    }

    @Override
    public boolean hasNext() {
        return this.m != 1;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        for (int i = 1; i <= this._length; ++i) {
            int n = this._pZ[i] - 1;
            this._currentPermutation.setValue(i - 1, ((ICombinatoricsVector)this._generator.getOriginalVector()).getValue(n));
        }
        this.m = this._length;
        while (this._pZ[this._pP[this.m] + this._pD[this.m]] > this.m) {
            this._pD[this.m] = -this._pD[this.m];
            --this.m;
        }
        this.pm = this._pP[this.m];
        this.dm = this.pm + this._pD[this.m];
        this.w = this._pZ[this.pm];
        this._pZ[this.pm] = this._pZ[this.dm];
        this._pZ[this.dm] = this.w;
        this.zpm = this._pZ[this.pm];
        this.w = this._pP[this.zpm];
        this._pP[this.zpm] = this.pm;
        this._pP[this.m] = this.w;
        ++this._currentIndex;
        return Factory.createVector(this._currentPermutation);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "PermutationIterator=[#" + this._currentIndex + ", " + this._currentPermutation + "]";
    }
}

