/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.combination.simple;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.combination.simple.SimpleCombinationIterator;
import org.paukov.combinatorics.util.Util;

public class SimpleCombinationGenerator<T>
extends Generator<T> {
    protected final ICombinatoricsVector<T> _originalVector;
    protected final int _combinationLength;

    public SimpleCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        this._originalVector = Factory.createVector(iCombinatoricsVector);
        this._combinationLength = n;
    }

    @Override
    public ICombinatoricsVector<T> getOriginalVector() {
        return this._originalVector;
    }

    public int getCombinationLength() {
        return this._combinationLength;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        return Util.combination(this._originalVector.getSize(), this._combinationLength);
    }

    @Override
    public Iterator<ICombinatoricsVector<T>> iterator() {
        return new SimpleCombinationIterator(this);
    }
}

