/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics;

import java.util.Arrays;
import java.util.HashSet;

public class IntegerVector {
    protected final int[] _vector;

    public IntegerVector() {
        this(0);
    }

    public IntegerVector(int n) {
        this._vector = new int[n];
    }

    public IntegerVector(int[] nArray, int n) {
        this._vector = new int[n];
        System.arraycopy(nArray, 0, this._vector, 0, n);
    }

    public IntegerVector(int[] nArray) {
        this(nArray, nArray.length);
    }

    public IntegerVector(IntegerVector integerVector) {
        this._vector = new int[integerVector.getSize()];
        System.arraycopy(integerVector._vector, 0, this._vector, 0, integerVector.getSize());
    }

    public void setValue(int n, int n2) {
        this._vector[n] = n2;
    }

    public int getValue(int n) {
        return this._vector[n];
    }

    public int getSize() {
        if (this._vector == null) {
            return 0;
        }
        return this._vector.length;
    }

    public boolean hasDuplicates() {
        if (this._vector.length <= 1) {
            return false;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this._vector.length; ++i) {
            hashSet.add(this._vector[i]);
        }
        return hashSet.size() < this._vector.length;
    }

    public boolean isAllElementsEqual() {
        if (this._vector.length == 0) {
            return false;
        }
        if (this._vector.length == 1) {
            return true;
        }
        for (int i = 0; i < this._vector.length - 1; ++i) {
            if (this._vector[i] == this._vector[i + 1]) continue;
            return false;
        }
        return true;
    }

    public int[] getVector() {
        return this._vector;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._vector == null ? 0 : Arrays.hashCode(this._vector));
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntegerVector integerVector = (IntegerVector)object;
        if (this._vector == integerVector._vector) {
            return true;
        }
        if (this._vector == null) {
            return false;
        }
        if (integerVector._vector == null) {
            return false;
        }
        if (this._vector.length != integerVector._vector.length) {
            return false;
        }
        for (int i = 0; i < this._vector.length; ++i) {
            if (this._vector[i] == integerVector._vector[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IntegerVector=([");
        for (int i = 0; i < this._vector.length; ++i) {
            stringBuilder.append(this._vector[i]);
            if (i >= this._vector.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], size=" + this.getSize() + ")");
        return stringBuilder.toString();
    }
}

