/*
 * Decompiled with CFR 0.152.
 */
package neverlang.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.UndefinedAttributeException;

public class NonTerminalListIterator<T>
implements List<T>,
Serializable {
    protected final String collectAttribute;
    protected final List<T> collectedAttributes = new ArrayList<T>();
    protected final ASTNode n;
    protected final int attributeNode = 0;
    protected final int iterateNode = 1;

    public NonTerminalListIterator(ASTNode n, String collectAttribute) {
        this.collectAttribute = collectAttribute;
        this.n = n;
        this.collectAttributes();
    }

    NonTerminalListIterator(ASTNode n, String targetAttribute, boolean collectAll) {
        this.collectAttribute = targetAttribute;
        this.n = n;
        if (!collectAll) {
            this.collectAttributes();
        } else {
            this.collectAll(n);
        }
    }

    protected void collectAll(ASTNode n) {
        for (ASTNode child : n.ntchildren) {
            try {
                Object o = child.getValue(this.collectAttribute);
                this.collectedAttributes.add(o);
            }
            catch (UndefinedAttributeException e) {
                this.collectAll(child);
            }
        }
    }

    protected void collectAttributes() {
        ASTNode currentNode = this.n;
        ASTNode child = null;
        try {
            while (true) {
                child = currentNode.ntchild(0);
                Object o = child.getValue(this.collectAttribute);
                this.collectedAttributes.add(o);
                currentNode = currentNode.ntchild(1);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ex) {
            return;
        }
    }

    public String toString() {
        return this.collectedAttributes.toString();
    }

    @Override
    public int hashCode() {
        return this.collectedAttributes.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.collectedAttributes.equals(o);
    }

    @Override
    public int size() {
        return this.collectedAttributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collectedAttributes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collectedAttributes.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.collectedAttributes.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.collectedAttributes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.collectedAttributes.toArray(ts);
    }

    @Override
    public boolean add(T e) {
        return this.collectedAttributes.add(e);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        return this.collectedAttributes.containsAll(clctn);
    }

    @Override
    public boolean addAll(Collection<? extends T> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T get(int i) {
        return this.collectedAttributes.get(i);
    }

    @Override
    public T set(int i, T e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(int i, T e) {
        this.collectedAttributes.add(i, e);
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        return this.collectedAttributes.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.collectedAttributes.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.collectedAttributes.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.collectedAttributes.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return this.collectedAttributes.subList(i, i1);
    }

    public List<T> asJavaList() {
        return this.collectedAttributes;
    }
}

