/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime.dexter;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.TerminalSym;
import dexter.lexter.KeywordTerminalSym;
import dexter.parser.DynamicParserException;
import dexter.parser.ITokenStream;
import dexter.parser.Item;
import dexter.parser.Kernel;
import dexter.parser.LookaheadSet;
import dexter.parser.ParserState;
import dexter.parser.UnexpectedSymbolException;
import dexter.parser.ast.NodeStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import neverlang.runtime.dexter.ParsingStrategy;

public class LALRParsingStrategy
implements ParsingStrategy {
    Grammar g;

    public LALRParsingStrategy(Grammar g) {
        this.g = g;
    }

    public Collection<TerminalSym> getNextTerminalSymbols(ParserState state, TerminalSym tokenSym) {
        HashSet<TerminalSym> set = new HashSet<TerminalSym>(state.goTo.getTerminalSymbols());
        System.out.println("about to visit: ");
        this.printWithLookahead((ParserState)state.goTo.get(tokenSym));
        for (ParserState thestate : Arrays.asList(state, (ParserState)state.goTo.get(tokenSym))) {
            for (ParserState nxt : thestate.goTo.values()) {
                set.addAll(nxt.goTo.getTerminalSymbols());
            }
            for (Item k : thestate.kernel) {
                set.addAll(thestate.kernel.getLookahead(k));
            }
        }
        ArrayList<TerminalSym> orderedList = new ArrayList<TerminalSym>(set.size());
        for (TerminalSym first : set) {
            if (!(first instanceof KeywordTerminalSym)) continue;
            orderedList.add(first);
        }
        for (TerminalSym last : set) {
            if (last instanceof KeywordTerminalSym) continue;
            orderedList.add(last);
        }
        return orderedList;
    }

    private void printWithLookahead(ParserState state) {
        Kernel k = state.kernel;
        for (Item i : k) {
            LookaheadSet la = k.getLookahead(i);
            System.out.println("  " + i + la);
        }
        System.out.println("  goto: " + state.goTo.getTerminalSymbols());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Item parse(ParserState state, ITokenStream tokens, NodeStack stack) {
        TerminalSym tokenSym;
        block9: {
            System.out.println("entering: ");
            this.printWithLookahead(state);
            tokenSym = tokens.peek();
            System.out.println("tok: " + tokenSym);
            if (!state.goTo.containsKey(tokenSym)) {
                if (state.goTo.containsKey(Grammar.EPSILON)) {
                    tokenSym = Grammar.EPSILON;
                    break block9;
                } else {
                    if (!state.isTerminalState()) throw new UnexpectedSymbolException(tokenSym, state.goTo.getTerminalSymbols(), state);
                    return state.reduce(tokenSym);
                }
            }
            HashSet<TerminalSym> ts = new HashSet<TerminalSym>();
            ParserState nextState = (ParserState)state.goTo.get(tokenSym);
            ts.addAll(nextState.goTo.getTerminalSymbols());
            ts.add(Grammar.EPSILON);
            if (ts.isEmpty()) {
                for (Item k : nextState.kernel.getCandidates()) {
                    ts.addAll(nextState.kernel.getLookahead(k));
                }
            }
            tokens.getNext(ts);
        }
        stack.push(tokenSym);
        Item reduceByRule = this.parse((ParserState)state.goTo.get(tokenSym), tokens, stack);
        NonTerminalSym reduceByNT = reduceByRule.nt;
        System.out.println("reduced by " + reduceByNT);
        if (reduceByRule.pos == 0) {
            stack.reduce(reduceByRule.toProduction());
        }
        while (!reduceByRule.isKernel()) {
            if (!state.goTo.containsKey(reduceByNT)) {
                throw new DynamicParserException("Could not reduce by " + reduceByNT + " " + state.goTo + " in " + state.toString());
            }
            reduceByRule = this.parse((ParserState)state.goTo.get(reduceByNT), tokens, stack);
            reduceByNT = reduceByRule.nt;
            System.out.println("reduce by " + reduceByNT);
            if (reduceByRule.pos != 0) continue;
            stack.reduce(reduceByRule.toProduction());
        }
        return reduceByRule.prev();
    }
}

