/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.Production;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import neverlang.runtime.IdRoleDef;
import neverlang.runtime.Module;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.RoleDef;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.Syntax;
import neverlang.runtime.Unit;

public abstract class SliceMerge
extends Unit
implements ModuleInterface {
    protected HashMap<String, Module> moduleInstanceMap = new HashMap();
    protected HashMap<String, Module> roleModuleInstanceMap = new HashMap();
    protected HashMap<String, RoleDef> roledefMap = new HashMap();
    protected Syntax syntax = null;

    protected void importSyntax(String fromModule) {
        String syntaxModule = fromModule + "$role$syntax";
        Object o = this.loadClass(syntaxModule);
        if (!(o instanceof Syntax)) {
            throw new RuntimeException("Cannot find valid syntax module : " + syntaxModule);
        }
        this.syntax = (Syntax)o;
    }

    protected void imports(String fromModule, RoleDef ... roles) {
        if (roles.length == 0) {
            throw new RuntimeException("You must specify at least one role");
        }
        Object o = this.loadClass(fromModule);
        if (!(o instanceof Module) || o == null) {
            return;
        }
        Module m = (Module)o;
        this.moduleInstanceMap.put(fromModule, m);
        for (RoleDef r : roles) {
            if (!m.hasRole(r.getName())) {
                throw new RuntimeException(String.format("Module %s: role %s is missing or empty!", m.getCanonicalName(), r));
            }
            if (this.roleModuleInstanceMap.containsKey(r.getName())) {
                Module old = this.roleModuleInstanceMap.get(r.getName());
                old.merge(m);
            } else {
                this.roleModuleInstanceMap.put(r.getName(), m);
            }
            this.roledefMap.put(r.getName(), r);
        }
    }

    protected void importRoles(String fromModule, String ... roleNames) {
        RoleDef[] roles = new RoleDef[roleNames.length];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new RoleDef(roleNames[i], this.syntax);
        }
        this.imports(fromModule, roles);
    }

    protected RoleDef role(String role2) {
        return new RoleDef(role2, this.syntax);
    }

    @Override
    public SemanticAction getAction(String role2, int pos) {
        Module m = this.roleModuleInstanceMap.get(role2);
        RoleDef rd = this.roledefMap.get(role2);
        for (String s : this.roleModuleInstanceMap.keySet()) {
            Module x = this.roleModuleInstanceMap.get(s);
            System.out.println("Name 1: " + s);
            System.out.println("Name 2: " + x.getName());
        }
        System.out.println("getAction::: role:" + role2 + " pos: " + pos);
        System.out.println("getAction::: module:" + m.getPackageName() + "." + m.getName());
        System.out.println("getAction::: roleDef:" + rd.getName());
        if (m != null) {
            return m.getAction(role2, rd.image(pos));
        }
        return null;
    }

    @Override
    public Production[] getSyntax() {
        return this.syntax.getProductions();
    }

    @Override
    public Syntax getSyntaxRole() {
        return this.syntax;
    }

    @Override
    public boolean hasRole(String role2) {
        return this.roleModuleInstanceMap.containsKey(role2);
    }

    @Override
    public boolean hasAction(String role2, int pos) {
        RoleDef rd = this.roledefMap.get(role2);
        return this.hasRole(role2) ? this.roleModuleInstanceMap.get(role2).getAction(role2, rd.image(pos)) != null : false;
    }

    @Override
    public String[] getRoles() {
        return this.roledefMap.keySet().toArray(new String[0]);
    }

    @Override
    public RoleDef getRoleDef(String role2) {
        if (!this.roledefMap.containsKey(role2)) {
            this.roledefMap.put(role2, new IdRoleDef(role2));
        }
        return this.roledefMap.get(role2);
    }

    @Override
    public String[] getRequiredEndemicSlices() {
        HashSet<String> set = new HashSet<String>();
        for (ModuleInterface moduleInterface : this.roleModuleInstanceMap.values()) {
            set.addAll(Arrays.asList(moduleInterface.getRequiredEndemicSlices()));
        }
        return set.toArray(new String[0]);
    }
}

