/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.Production;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import neverlang.runtime.IdRoleDef;
import neverlang.runtime.Module;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.MultiSemanticAction;
import neverlang.runtime.NOPSemanticAction;
import neverlang.runtime.RoleDef;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.Syntax;
import neverlang.runtime.Unit;
import neverlang.utils.Tuple;

public abstract class Slice
extends Unit
implements ModuleInterface {
    protected HashMap<String, Module> moduleInstanceMap = new LinkedHashMap<String, Module>();
    protected HashMap<String, List<Module>> roleModuleInstanceMap = new HashMap();
    protected HashMap<String, RoleDef> roledefMap = new HashMap();
    protected Syntax syntax = null;

    protected void importSyntax(String fromModule) {
        String syntaxModule = fromModule + "$role$syntax";
        Object o = this.loadClass(syntaxModule);
        if (!(o instanceof Syntax)) {
            throw new RuntimeException("Cannot find valid syntax module : " + syntaxModule);
        }
        this.syntax = (Syntax)o;
    }

    protected void imports(String fromModule, RoleDef ... roles) {
        if (roles.length == 0) {
            throw new RuntimeException("You must specify at least one role");
        }
        Object o = this.loadClass(fromModule);
        if (!(o instanceof Module) || o == null) {
            return;
        }
        Module m = (Module)o;
        this.moduleInstanceMap.put(fromModule, m);
        for (RoleDef r : roles) {
            List<Object> lst;
            if (!m.hasRole(r.getName())) {
                throw new RuntimeException(String.format("Module %s: role %s is missing or empty!", m.getCanonicalName(), r));
            }
            if (this.roleModuleInstanceMap.containsKey(r.getName())) {
                lst = this.roleModuleInstanceMap.get(r.getName());
                lst.add(m);
            } else {
                lst = new ArrayList<Module>();
                ((ArrayList)lst).add(m);
                this.roleModuleInstanceMap.put(r.getName(), lst);
            }
            this.roledefMap.put(r.getName(), r);
        }
    }

    protected void importRoles(String fromModule, String ... roleNames) {
        RoleDef[] roles = new RoleDef[roleNames.length];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new RoleDef(roleNames[i], this.syntax);
        }
        this.imports(fromModule, roles);
    }

    protected RoleDef role(String role2) {
        return new RoleDef(role2, this.syntax);
    }

    @Override
    public SemanticAction getAction(String role2, int pos) {
        try {
            List<Module> lst = this.roleModuleInstanceMap.get(role2);
            RoleDef rd = this.roledefMap.get(role2);
            ArrayList<SemanticAction> actions = new ArrayList<SemanticAction>();
            for (Module m : lst) {
                SemanticAction current = m.getAction(role2, rd.image(pos));
                if (current instanceof NOPSemanticAction) continue;
                actions.add(current);
            }
            if (actions.size() == 1) {
                return (SemanticAction)actions.get(0);
            }
            if (actions.isEmpty()) {
                return null;
            }
            MultiSemanticAction msa = new MultiSemanticAction(actions);
            return msa;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public List<Tuple<Integer, SemanticAction>> getActions(String role2) {
        Collection modules = this.roleModuleInstanceMap.get(role2);
        ArrayList<Tuple<Integer, SemanticAction>> result = new ArrayList<Tuple<Integer, SemanticAction>>();
        for (Module m : modules) {
            for (Tuple<Integer, SemanticAction> act : m.getActions(role2)) {
                result.add(act);
            }
        }
        return result;
    }

    public List<String> getModules() {
        return new ArrayList<String>(this.moduleInstanceMap.keySet());
    }

    public Module getModule(String module) {
        return this.moduleInstanceMap.get(module);
    }

    public Production[] getModuleSyntax(String module) {
        Module mod = this.moduleInstanceMap.get(module);
        return mod.getSyntax();
    }

    @Override
    public Production[] getSyntax() {
        return this.syntax.getProductions();
    }

    @Override
    public Syntax getSyntaxRole() {
        return this.syntax;
    }

    @Override
    public boolean hasRole(String role2) {
        return this.roleModuleInstanceMap.containsKey(role2);
    }

    @Override
    public boolean hasAction(String role2, int pos) {
        if (!this.hasRole(role2)) {
            return false;
        }
        RoleDef rd = this.roledefMap.get(role2);
        List<Module> lst = this.roleModuleInstanceMap.get(role2);
        for (Module m : lst) {
            if (m.getAction(role2, rd.image(pos)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getRoles() {
        return this.roledefMap.keySet().toArray(new String[0]);
    }

    @Override
    public RoleDef getRoleDef(String role2) {
        if (!this.roledefMap.containsKey(role2)) {
            this.roledefMap.put(role2, new IdRoleDef(role2));
        }
        return this.roledefMap.get(role2);
    }

    @Override
    public String[] getRequiredEndemicSlices() {
        HashSet<String> set = new HashSet<String>();
        for (List<Module> lst : this.roleModuleInstanceMap.values()) {
            for (ModuleInterface moduleInterface : lst) {
                set.addAll(Arrays.asList(moduleInterface.getRequiredEndemicSlices()));
            }
        }
        return set.toArray(new String[0]);
    }

    @Override
    public void reset() {
        for (ModuleInterface moduleInterface : this.moduleInstanceMap.values()) {
            moduleInterface.reset();
        }
    }

    @Override
    public int getProductionPos(Production p) {
        return this.getSyntaxRole().getPos(p);
    }
}

