/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import neverlang.runtime.Context;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.dexter.ASTNode;
import neverlang.utils.Tuple;

public class MultiSemanticAction
implements SemanticAction,
Serializable {
    List<SemanticAction> actions;
    boolean createdFromActions = false;
    Comparator<SemanticAction> byPriority = (left, right) -> {
        if (left.getPriority() > right.getPriority()) {
            return -1;
        }
        return 1;
    };

    public MultiSemanticAction() {
        this.actions = null;
    }

    public MultiSemanticAction(List<SemanticAction> actions) {
        this.actions = this.flatten(actions);
        this.createdFromActions = true;
    }

    public void reset() {
        this.actions = this.loadActions();
    }

    private List<SemanticAction> flatten(List<SemanticAction> list) {
        ArrayList<SemanticAction> result = new ArrayList<SemanticAction>();
        LinkedList<SemanticAction> stack = new LinkedList<SemanticAction>(list);
        while (stack.size() > 0) {
            SemanticAction e = stack.remove();
            if (e instanceof MultiSemanticAction) {
                stack.addAll(0, ((MultiSemanticAction)e).getActions());
                continue;
            }
            result.add(e);
        }
        this.reorder(result);
        return result;
    }

    public void addAction(SemanticAction sa) {
        if (sa == null) {
            return;
        }
        this.actions.add(sa);
        this.actions = this.flatten(this.actions);
    }

    public void addActions(Collection<SemanticAction> actions) {
        for (SemanticAction sa : actions) {
            if (sa == null) continue;
            this.actions.add(sa);
        }
        this.actions = this.flatten(this.actions);
    }

    public void removeAction(SemanticAction sa) {
        this.actions.remove(sa);
        this.reorder();
    }

    public void reorder() {
        if (this.actions != null) {
            Collections.sort(this.actions, this.byPriority);
        }
    }

    private void reorder(List<SemanticAction> list) {
        Collections.sort(list, this.byPriority);
    }

    @Override
    public void apply(Context ctx) {
        ASTNode node = ctx.node();
        Tuple<SemanticAction, Context> defAct = node.getDefaultAction(ctx.roleId());
        if (defAct != null) {
            System.out.println("Default action!");
            SemanticAction sa = (SemanticAction)defAct.x;
            System.out.println("sa:" + sa.toString());
            if (sa.predicate(ctx)) {
                this.runAction(sa, (Context)defAct.y);
                return;
            }
        }
        if (this.actions == null) {
            this.actions = this.loadActions();
        }
        this.runActions(ctx);
    }

    protected void runActions(Context $ctx) {
        for (SemanticAction sa : this.actions) {
            if (!sa.predicate($ctx)) continue;
            this.runAction(sa, $ctx);
            return;
        }
    }

    protected void runAction(SemanticAction a, Context ctx) {
        try {
            a.apply(ctx);
            if (a.isSoftGuarded()) {
                ctx.node().setDefaultAction(a, ctx);
            }
        }
        catch (RuntimeException e) {
            String name = this.getClass().getName();
            String exceptionName = e.getClass().getName().replace(".", "_");
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                Class<?> clazz = cl.loadClass(name + exceptionName);
                SemanticAction sa = (SemanticAction)clazz.newInstance();
                this.runAction(sa, ctx);
            }
            catch (ClassNotFoundException ex) {
                throw e;
            }
            catch (IllegalAccessException | InstantiationException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    protected List<SemanticAction> loadActions() {
        ArrayList<SemanticAction> actionss = new ArrayList<SemanticAction>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.getClass().getName();
        int i = 0;
        while (true) {
            try {
                String current = name + "_" + i;
                Class<?> clazz = cl.loadClass(current);
                SemanticAction sa = (SemanticAction)clazz.newInstance();
                actionss.add(sa);
            }
            catch (ClassNotFoundException e) {
                break;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        Collections.sort(actionss, this.byPriority);
        return actionss;
    }

    public void setActions(List<SemanticAction> actions) {
        this.actions = actions;
    }

    protected SemanticAction loadAction(int pos) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader cl = this.getClass().getClassLoader();
        String name = this.getClass().getName();
        String current = name + "_" + pos;
        Class<?> clazz = cl.loadClass(current);
        SemanticAction sa = (SemanticAction)clazz.newInstance();
        return sa;
    }

    public List<SemanticAction> getActions() {
        if (this.actions == null) {
            this.actions = this.loadActions();
        }
        return this.actions;
    }

    @Override
    public void setPriority(int p) {
        throw new UnsupportedOperationException("A multi semantic action cannot have priorities.");
    }

    @Override
    public String getLabel() {
        throw new UnsupportedOperationException("A multi semantic action cannot be labeled");
    }

    public String toString() {
        return super.toString() + " from actions: " + this.createdFromActions;
    }
}

