/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.SimpleNonTerminalSym;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.ProductionClashException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import neverlang.runtime.Blue;
import neverlang.runtime.Bundle;
import neverlang.runtime.Context;
import neverlang.runtime.EndemicSlice;
import neverlang.runtime.LayeredRole;
import neverlang.runtime.Module;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.MultiSemanticAction;
import neverlang.runtime.NOPSemanticAction;
import neverlang.runtime.PostorderSemanticAction;
import neverlang.runtime.Role;
import neverlang.runtime.RoleDef;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.SemanticActionSequence;
import neverlang.runtime.Slice;
import neverlang.runtime.Syntax;
import neverlang.runtime.SyntaxRuleClashException;
import neverlang.runtime.TaggedNonterminal;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.Dexter;
import neverlang.runtime.dexter.ParsingException;
import neverlang.utils.FileUtils;
import neverlang.utils.Tuple;
import neverlang.utils.debug.GraphvizAST;

public abstract class Language
extends Bundle {
    protected Role[] roles = new Role[0];
    protected boolean reduceTree = false;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected HashMap<Production, ModuleInterface> productionToSlice = new HashMap();
    protected HashMap<Production, Production> renamedProductionMap = new HashMap();
    protected Dexter dx = new Dexter();
    private String instanceName = null;
    int score = 0;

    protected void declareRoles(String ... roleNames) {
        if (roleNames.length == 0) {
            throw new RuntimeException("Declare at least one role");
        }
        Role[] roleArr = new Role[roleNames.length];
        for (int i = 0; i < roleNames.length; ++i) {
            roleArr[i] = this.role(roleNames[i]);
        }
        this.roles = roleArr;
    }

    protected Role role(String name) {
        return this.role(name, Role.Flags.POSTORDER);
    }

    protected Role role(String name, Role.Flags f) {
        return new Role(name, f);
    }

    protected Role role(Role.Flags f, String name, String ... names) {
        if (names.length == 0) {
            return this.role(name, f);
        }
        Role[] roleArr = new Role[names.length + 1];
        roleArr[0] = new Role(name, f);
        for (int i = 0; i < names.length; ++i) {
            roleArr[i + 1] = new Role(names[i], f);
        }
        List<Role> roleList = Arrays.asList(roleArr);
        LayeredRole lr = new LayeredRole(roleList);
        return lr;
    }

    protected void declare(Role ... roles) {
        this.roles = roles;
    }

    @Override
    protected void importSlices(String slice, String ... slices) {
        super.importSlices(slice, slices);
    }

    protected void importBundles(String bundle, String ... moreBundles) {
        this.loadBundle(bundle);
        for (String moreBundle : moreBundles) {
            this.loadBundle(moreBundle);
        }
    }

    @Deprecated
    public ASTNode interpret(String source) throws ParsingException {
        return this.exec(source);
    }

    public ASTNode exec(String source) throws ParsingException {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        ASTNode t = this.parse(source);
        this.execTree(t);
        return t;
    }

    public ASTNode exec(String source, File file) throws ParsingException {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        ASTNode t = this.parse(source);
        t.setFile(file);
        this.execTree(t);
        return t;
    }

    public ASTNode exec(ASTNode t) throws ParsingException {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        this.execTree(t);
        return t;
    }

    public void dumpTree(ASTNode tree, String filename) throws FileNotFoundException {
        if (tree == null) {
            System.out.println("Tree is null. Dump skipped.");
            return;
        }
        String fname = filename + ".dot";
        String fpath = new File(".").getAbsolutePath() + "/" + fname;
        String dumped = new GraphvizAST(tree).toString();
        FileUtils.stringToFile(dumped, fpath);
    }

    protected void execTree(ASTNode t) {
        this.invalidateCache();
        this.injectEndemicSlices(t);
        if (this.instanceName != null && !this.instanceName.isEmpty()) {
            t.setValue("__StubName", this.getInstanceName());
        }
        try {
            block7: for (int roleId = 0; roleId < this.roles.length; ++roleId) {
                Role role2 = this.roles[roleId];
                switch (role2.flag) {
                    case MANUAL: {
                        this.preorder(new Context(t, t, this, role2, roleId));
                        continue block7;
                    }
                    case POSTORDER: {
                        this.postorder(new Context(t, t, this, role2, roleId));
                        continue block7;
                    }
                    case PREORDER: {
                        this.preorder(new Context(t, t, this, role2, roleId));
                    }
                }
            }
        }
        catch (Blue blue) {
            // empty catch block
        }
    }

    private void injectEndemicSlices(ASTNode t) {
        for (EndemicSlice endemic : this.endemicSliceList) {
            endemic.declarations();
            Map<String, Object> instances = endemic.getDeclaredInstances();
            Map<String, Object> staticInstances = endemic.getDeclaredStaticInstances();
            for (String sliceName : instances.keySet()) {
                t.setValue("$" + sliceName, instances.get(sliceName));
            }
            for (String sliceName : staticInstances.keySet()) {
                t.setValue("$" + sliceName, staticInstances.get(sliceName));
            }
        }
    }

    public void setLeftAssociative(String ... sliceNames) {
        List<String> sliceNamesList = Arrays.asList(sliceNames);
        for (String sliceName : this.getSlices().keySet()) {
            Production[] productions;
            if (!sliceNamesList.contains(sliceName)) continue;
            ModuleInterface mi = this.getSlice(sliceName);
            for (Production prod : productions = mi.getSyntax()) {
                prod.setRightAssociative(false);
                prod.setScore(this.score);
            }
        }
        this.score += 100;
    }

    public Map<NonTerminalSym, List<ModuleInterface>> checkDependencies() {
        Map<String, ModuleInterface> slices = this.getSlices();
        HashMap<NonTerminalSym, ArrayList<ModuleInterface>> providedBy = new HashMap<NonTerminalSym, ArrayList<ModuleInterface>>();
        for (ModuleInterface m : slices.values()) {
            TaggedNonterminal[] provides;
            Syntax syn = m.getSyntaxRole();
            for (TaggedNonterminal tnt : provides = syn.getProvides()) {
                ArrayList<ModuleInterface> satisfyingModules = (ArrayList<ModuleInterface>)providedBy.get(tnt.getNonterminal());
                if (satisfyingModules == null) {
                    satisfyingModules = new ArrayList<ModuleInterface>();
                    providedBy.put(tnt.getNonterminal(), satisfyingModules);
                }
                satisfyingModules.add(m);
            }
        }
        HashMap<NonTerminalSym, List<ModuleInterface>> unsatReq = new HashMap<NonTerminalSym, List<ModuleInterface>>();
        for (ModuleInterface m : this.getSlices().values()) {
            TaggedNonterminal[] requires;
            Syntax syn = m.getSyntaxRole();
            for (TaggedNonterminal tnt : requires = syn.getRequires()) {
                List satisfyingModules = (List)providedBy.get(tnt.getNonterminal());
                if (satisfyingModules != null && !satisfyingModules.isEmpty()) continue;
                List<ModuleInterface> unsatModuleList = unsatReq.get(tnt.getNonterminal());
                if (unsatModuleList == null) {
                    unsatModuleList = new ArrayList<ModuleInterface>();
                    unsatReq.put(tnt.getNonterminal(), unsatModuleList);
                }
                unsatModuleList.add(m);
            }
        }
        return unsatReq;
    }

    public ASTNode parse(String source) throws ParsingException {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        if (!this.dx.parse(source)) {
            return null;
        }
        return this.dx.getLastParseTree();
    }

    public ASTNode parse(String source, File file) throws ParsingException {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        if (!this.dx.parse(source)) {
            return null;
        }
        ASTNode result = this.dx.getLastParseTree();
        result.setFile(file);
        return result;
    }

    protected void postorder(Context ctx) {
        ASTNode n = ctx.node();
        if (n.getSymbol() instanceof TerminalSym) {
            return;
        }
        if (n.productionPos == -1) {
            Production p = n.getProduction();
            n.productionPos = this.getProductionPos(p);
        }
        int start = n.productionPos;
        int pos = start + 1;
        ctx.setOffset(start);
        for (ASTNode c : n.children()) {
            if (c.getSymbol() instanceof TerminalSym) continue;
            this.postorder(ctx.derive(c));
            this.invokeAction(ctx, pos);
            ++pos;
        }
        this.invokeAction(ctx, start);
    }

    protected void preorder(Context ctx) {
        SemanticAction currentAction;
        ASTNode n = ctx.node();
        if (n.getSymbol() instanceof TerminalSym) {
            return;
        }
        if (n.productionPos == -1) {
            Production p = n.getProduction();
            n.productionPos = this.getProductionPos(p);
        }
        int start = n.productionPos;
        int pos = start + 1;
        ctx.setOffset(start);
        Tuple<SemanticAction, Context> defaultAction = n.getDefaultAction(ctx.roleId());
        if (defaultAction == null) {
            currentAction = this.getAction(ctx, start);
        } else {
            currentAction = (SemanticAction)defaultAction.x;
            ctx = (Context)defaultAction.y;
        }
        List<SemanticAction> removedActions = n.getRemovedActions(ctx.roleId());
        if (!removedActions.isEmpty()) {
            System.out.println("Removed actions for role id: " + ctx.roleId() + " node:" + n.toShortString(70));
            for (SemanticAction sa : removedActions) {
                System.out.println("- " + sa);
            }
            System.out.println("\nx ");
        }
        SemanticAction mainAction = currentAction;
        if (!(currentAction instanceof PostorderSemanticAction)) {
            if (currentAction.predicate(ctx)) {
                if (currentAction.isSoftGuarded()) {
                    n.setDefaultAction(currentAction, ctx);
                }
                currentAction.apply(ctx);
            }
            currentAction = null;
        }
        if (this.isNOP(mainAction)) {
            for (ASTNode c : n.children()) {
                if (c.getSymbol() instanceof TerminalSym) continue;
                SemanticAction nextAction = this.getAction(ctx, pos);
                if (nextAction instanceof PostorderSemanticAction) {
                    this.preorder(ctx.derive(c));
                    if (!nextAction.predicate(ctx)) continue;
                    nextAction.apply(ctx);
                    if (!nextAction.isSoftGuarded()) continue;
                    c.setDefaultAction(nextAction, ctx);
                    continue;
                }
                if (nextAction.predicate(ctx)) {
                    nextAction.apply(ctx);
                    if (nextAction.isSoftGuarded()) {
                        c.setDefaultAction(nextAction, ctx);
                    }
                }
                this.preorder(ctx.derive(c));
            }
            ++pos;
        }
        if (currentAction != null && currentAction.predicate(ctx)) {
            currentAction.apply(ctx);
            if (currentAction.isSoftGuarded()) {
                n.setDefaultAction(currentAction, ctx);
            }
        }
    }

    public void eval(Context ctx) {
        this.preorder(ctx);
    }

    private void eval(Context ctx, int ntNum) {
        this.invokeAction(ctx, ntNum);
    }

    private boolean isNOP(SemanticAction sa) {
        if (sa instanceof SemanticActionSequence) {
            SemanticActionSequence saseq = (SemanticActionSequence)sa;
            sa = saseq.last();
        }
        return sa == null || sa instanceof NOPSemanticAction;
    }

    protected void invokeAction(Context ctx, int pos) {
        SemanticAction sa;
        ASTNode n = ctx.node();
        Tuple<SemanticAction, Context> defaultAction = n.getDefaultAction(ctx.roleId());
        if (defaultAction == null) {
            sa = this.getAction(ctx, pos);
        } else {
            sa = (SemanticAction)defaultAction.x;
            ctx = (Context)defaultAction.y;
        }
        if (sa != null && sa.predicate(ctx)) {
            sa.apply(ctx);
            if (sa.isSoftGuarded()) {
                n.setDefaultAction(sa, ctx);
            }
        }
    }

    public SemanticAction getAction(Context ctx) {
        ASTNode n = ctx.node();
        if (n.getSymbol() instanceof TerminalSym) {
            return NOPSemanticAction.instance;
        }
        if (n.productionPos == -1) {
            Production p = n.getProduction();
            n.productionPos = this.getProductionPos(p);
        }
        int start = n.productionPos;
        ctx.setOffset(start);
        Tuple<SemanticAction, Context> defaultAction = n.getDefaultAction(ctx.roleId());
        if (defaultAction == null) {
            return this.getAction(ctx, start);
        }
        return (SemanticAction)defaultAction.x;
    }

    public SemanticAction getAction(Context ctx, int pos) {
        Role role2 = ctx.role();
        Production p = ctx.node().getProduction();
        if (role2 instanceof LayeredRole) {
            LayeredRole lr = (LayeredRole)role2;
            SemanticActionSequence saseq = new SemanticActionSequence();
            for (Role r : lr.roles) {
                ModuleInterface s = this.productionToSlice.get(p);
                SemanticAction sa = s.getAction(r.getName(), pos);
                if (sa == null) continue;
                RoleDef rd = s.getRoleDef(r.getName());
                saseq.add(sa, rd);
            }
            return saseq;
        }
        ModuleInterface s = this.productionToSlice.get(p);
        if (s == null) {
            System.out.println("Slice is null for production: " + p);
        }
        SemanticAction sa = s.getAction(role2.getName(), pos);
        ctx.roleDef(s.getRoleDef(role2.getName()));
        ASTNode node = ctx.node();
        List<SemanticAction> nodeActions = node.getFilteredActions(ctx.roleId());
        if (nodeActions == null || nodeActions.isEmpty() && !node.isRemoved(sa, ctx.roleId())) {
            return sa;
        }
        if (node.isRemoved(sa, ctx.roleId())) {
            return new MultiSemanticAction(nodeActions);
        }
        if (sa instanceof MultiSemanticAction) {
            MultiSemanticAction msa = (MultiSemanticAction)sa;
            if (node.shouldReconsiderActions()) {
                msa.reset();
                msa.addActions(nodeActions);
                return msa;
            }
            return msa;
        }
        MultiSemanticAction newMSA = new MultiSemanticAction(nodeActions);
        newMSA.addAction(sa);
        return newMSA;
    }

    private Production getRenamedProduction(Production p) {
        if (this.renamedProductionMap.isEmpty()) {
            return p;
        }
        if (this.renamedProductionMap.containsKey(p)) {
            return this.renamedProductionMap.get(p);
        }
        return p;
    }

    public int getProductionPos(Production p) {
        Production pp = this.getRenamedProduction(p);
        return this.productionToSlice.get(p).getSyntaxRole().getPos(pp);
    }

    protected void loadSyntax() {
        for (ModuleInterface m : this.classSliceMap.values()) {
            this.loadSyntax(m);
        }
        this.dx.commit();
    }

    private void loadSyntax(ModuleInterface s) {
        int pos = 0;
        for (Production p : s.getSyntax()) {
            Production pp = this.preprocessProduction(p);
            try {
                this.dx.add(pp);
            }
            catch (ProductionClashException e) {
                throw new SyntaxRuleClashException(this.productionToSlice.get(e.getProduction()), s, e.getProduction());
            }
            this.productionToSlice.put(pp, s);
            pos += this.countNonterminals(pp);
        }
    }

    private int countNonterminals(Production p) {
        int i = 1;
        for (Symbol s : p.body) {
            if (!(s instanceof NonTerminalSym)) continue;
            ++i;
        }
        return i;
    }

    private Production preprocessProduction(Production p) {
        NonTerminalSym nt = p.nt;
        boolean headChanged = false;
        if (this.renameMap.containsKey(p.nt.toString())) {
            nt = new SimpleNonTerminalSym((String)this.renameMap.get(p.nt.toString()));
            headChanged = true;
        }
        boolean bodyChanged = false;
        for (Symbol s : p.body) {
            if (!(s instanceof NonTerminalSym) || !this.renameMap.containsKey(s.toString())) continue;
            bodyChanged = true;
            break;
        }
        if (bodyChanged) {
            ArrayList<Symbol> body = new ArrayList<Symbol>(p.body);
            for (int i = 0; i < body.size(); ++i) {
                Symbol s = (Symbol)body.get(i);
                if (!(s instanceof NonTerminalSym)) continue;
                if (this.renameMap.containsKey(s.toString())) {
                    s = new SimpleNonTerminalSym((String)this.renameMap.get(s.toString()));
                }
                body.set(i, s);
            }
            Production pp = new Production(nt, body);
            pp.setLabel(p.getLabel());
            this.renamedProductionMap.put(pp, p);
            return pp;
        }
        if (headChanged) {
            Production pp = new Production(nt, p.body);
            pp.setLabel(p.getLabel());
            this.renamedProductionMap.put(pp, p);
            return pp;
        }
        return p;
    }

    public Dexter getDexter() {
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        return this.dx;
    }

    private void loadBundle(String bundleClassName) {
        Object o = this.loadClass(bundleClassName);
        if (!(o instanceof Bundle) || o == null) {
            throw new RuntimeException("could not load bundle " + bundleClassName);
        }
        Bundle bndl = (Bundle)o;
        for (ModuleInterface slc : bndl.getSlices().values()) {
            this.classSliceMap.put(slc.getName(), slc);
        }
        for (EndemicSlice end : bndl.getEndemicSlices()) {
            this.endemicSliceList.add(end);
        }
        this.renameMap.putAll(bndl.getRenames());
    }

    public void reduceTree(boolean reduce) {
        this.reduceTree = reduce;
    }

    public boolean reduceTree() {
        return this.reduceTree;
    }

    public Context deriveContextByRoleName(Context ctx, ASTNode targetNode, String roleName) {
        int roleId;
        Role role2 = null;
        for (roleId = 0; roleId < this.roles.length; ++roleId) {
            Role r = this.roles[roleId];
            if (!r.getName().equals(roleName)) continue;
            role2 = r;
            break;
        }
        if (role2 == null) {
            throw new RuntimeException("Role " + roleName + " undefined.");
        }
        System.out.println("role: " + role2 + " id: " + roleId);
        return new Context(ctx.root(), targetNode, this, role2, roleId);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ModuleInterface getSlice(Production p) {
        return this.productionToSlice.get(p);
    }

    public ASTNode getLastParseTree() {
        return this.dx.getLastParseTree();
    }

    private void reset() {
        for (ModuleInterface mi : this.getSlices().values()) {
            System.out.println("Resetting " + mi);
            mi.reset();
        }
    }

    public int getRoleId(Role role2) {
        int roleId = 0;
        for (Role r : this.getRoles()) {
            if (r.equals(role2)) {
                return roleId;
            }
            ++roleId;
        }
        throw new RuntimeException("Role " + role2 + " undefined.");
    }

    protected void invalidateCache() {
    }

    public Role[] getRoles() {
        return this.roles;
    }

    public Role getRoleByName(String name) {
        for (Role r : this.roles) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        throw new RuntimeException("Role " + name + " undefined.");
    }

    public Role getRoleById(int id) throws IndexOutOfBoundsException {
        return this.roles[id];
    }

    public Production[] getModuleGrammar(String moduleName) {
        Map<String, ModuleInterface> slices = this.getSlices();
        for (String sliceName : slices.keySet()) {
            ModuleInterface mi = this.getSlice(sliceName);
            if (mi == null) continue;
            if (mi instanceof Slice) {
                Slice slice = (Slice)mi;
                Module module = slice.getModule(moduleName);
                if (module == null) {
                    if (!slice.getName().equals(moduleName)) continue;
                    return slice.getSyntax();
                }
                if (!module.getName().equals(moduleName)) continue;
                return module.getSyntax();
            }
            if (!mi.getName().equals(moduleName)) continue;
            return mi.getSyntax();
        }
        throw new RuntimeException("No modules named: " + moduleName);
    }

    public Production[] getModuleGrammar(String slice, String module) {
        ModuleInterface mi = this.getSlice(slice);
        if (mi == null) {
            throw new RuntimeException("No slice with name: " + slice);
        }
        if (mi instanceof Slice) {
            return ((Slice)mi).getModuleSyntax(module);
        }
        return mi.getSyntax();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void enableEventNotifications(boolean b) {
        throw new UnsupportedOperationException("Event notifications are supported only if compiled for debugging.");
    }
}

