/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import neverlang.runtime.Language;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.Resume;
import neverlang.runtime.Role;
import neverlang.runtime.RoleDef;
import neverlang.runtime.UndeclaredSingletonException;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.UndefinedAttributeException;

public class Context {
    private ASTNode root;
    private ASTNode node;
    private Language lang;
    private Role role;
    private RoleDef roleDef;
    private int roleId;
    private int offset = Integer.MIN_VALUE;
    private boolean terminated;
    private boolean[] visited;
    private int[] visitCounter;

    public Context(ASTNode root, ASTNode node, Language lang, Role role2, int roleId) {
        this(root, node, lang, role2, roleId, false);
        this.visited = new boolean[node.ntchildren.length];
        this.visitCounter = new int[node.ntchildren.length];
    }

    public Context(ASTNode root, ASTNode node, Language lang, Role role2, int roleId, boolean terminated) {
        this.root = root;
        this.node = node;
        this.lang = lang;
        this.role = role2;
        this.roleId = roleId;
        this.terminated = terminated;
        this.visited = new boolean[node.ntchildren.length];
        this.visitCounter = new int[node.ntchildren.length];
    }

    public void eval(ASTNode targetNode) {
        try {
            this.lang.eval(this.derive(targetNode));
        }
        catch (UndefinedAttributeException ex) {
            ex.setPreorder();
            throw ex;
        }
    }

    public <T> T evalReturn(ASTNode targetNode, String valueId) {
        try {
            this.lang.eval(this.derive(targetNode));
            return targetNode.getValue(valueId);
        }
        catch (UndefinedAttributeException ex) {
            ex.setPreorder();
            throw ex;
        }
    }

    public void evalChildren(ASTNode targetNode) {
        for (ASTNode child : targetNode.ntchildren) {
            this.eval(child);
        }
    }

    public Context terminated() {
        return new Context(this.root, this.node, this.lang, this.role, this.roleId, true);
    }

    public void suspend() {
        this.role = this.lang.roles[++this.roleId];
        try {
            this.eval(this.root);
        }
        catch (Resume resume) {
            // empty catch block
        }
        this.role = this.lang.roles[--this.roleId];
    }

    public void resume() {
        this.role = this.lang.roles[--this.roleId];
        throw Resume.Signal;
    }

    public ASTNode root() {
        return this.root;
    }

    public ASTNode node() {
        return this.node;
    }

    public ASTNode nt(int pos) {
        try {
            int cached = this.node.childrenOffset.get(pos);
            if (cached != 0) {
                if (cached == -1) {
                    return this.node;
                }
                return this.node.ntchild(cached - 1);
            }
            int childId = this.calcOffset(pos);
            if (childId == 0) {
                this.node.childrenOffset.put(pos, -1);
                return this.node;
            }
            this.node.childrenOffset.put(pos, childId);
            return this.node.ntchild(childId - 1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            throw new ArrayIndexOutOfBoundsException(pos);
        }
    }

    public ASTNode t(int pos) {
        return this.node.tchild(pos);
    }

    public Role role() {
        return this.role;
    }

    public RoleDef roleDef() {
        return this.roleDef;
    }

    public void roleDef(RoleDef roleDef) {
        this.roleDef = roleDef;
    }

    public <T> T singleton(String className) {
        try {
            return this.root.getValue(className);
        }
        catch (UndefinedAttributeException ex) {
            throw new UndeclaredSingletonException(className);
        }
    }

    public Context derive(ASTNode targetNode) {
        return new Context(this.root, targetNode, this.lang, this.role, this.roleId, this.terminated);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private int calcOffset(int ntIndex) {
        int result = Math.abs(this.remap(ntIndex) - this.offset);
        return result;
    }

    private int remap(int pos) {
        return this.roleDef.preimage(this.node, pos);
    }

    public <T> T getEndemic(String name) {
        return this.root().getValue("$" + name);
    }

    public Language getLang() {
        return this.lang;
    }

    public int roleId() {
        return this.roleId;
    }

    public Context copy() {
        Context ctx = new Context(this.root, this.node, this.lang, this.role, this.roleId);
        ctx.roleDef = this.roleDef;
        ctx.offset = this.offset;
        ctx.terminated = this.terminated;
        System.arraycopy(this.visited, 0, ctx.visited, 0, this.visited.length);
        System.arraycopy(this.visitCounter, 0, ctx.visitCounter, 0, this.visitCounter.length);
        return ctx;
    }

    public Context changeRole(Role role2, int roleId) {
        Context ctx = this.copy();
        ctx.role = role2;
        ctx.roleId = roleId;
        return ctx;
    }

    public void setRoot(ASTNode nroot) {
        this.root = nroot;
    }

    public ModuleInterface getSlice() {
        return this.lang.getSlice(this.node.getProduction());
    }
}

