/*
 * Decompiled with CFR 0.152.
 */
package neverlang.runtime;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import neverlang.runtime.EndemicSlice;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.Rename;
import neverlang.runtime.Unit;

public class Bundle
extends Unit {
    public static boolean DEFERRED_SYNTAX_LOADING = true;
    public static boolean USE_ORDERED_HASHMAP = true;
    protected Map<String, ModuleInterface> classSliceMap = Bundle.initMap();
    List<EndemicSlice> endemicSliceList = new ArrayList<EndemicSlice>();
    protected List<Rename> renames = new ArrayList<Rename>();
    HashMap<String, String> renameMap = new HashMap();

    protected void importSlices(String slice, String ... slices) {
        this.importSlice(slice);
        for (String s : slices) {
            this.importSlice(s);
        }
    }

    public ModuleInterface removeSlice(String sliceName) {
        return this.classSliceMap.remove(sliceName);
    }

    public ModuleInterface importSlice(String sliceClassName) {
        Object o = this.loadClass(sliceClassName);
        if (!(o instanceof ModuleInterface) || o == null) {
            throw new RuntimeException("could not load slice " + sliceClassName);
        }
        ModuleInterface s = (ModuleInterface)o;
        this.classSliceMap.put(sliceClassName, s);
        return s;
    }

    public ModuleInterface importSlice(String sliceClassName, String classPath) {
        URLClassLoader urlClassLoader;
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            urlClassLoader = new URLClassLoader(new URL[]{new File(classPath).toURI().toURL()}, currentThreadClassLoader);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        return this.importSlice(sliceClassName);
    }

    protected void importEndemicSlices(String endemic, String ... endemics) {
        this.importEndemicSlice(endemic);
        for (String s : endemics) {
            this.importEndemicSlice(s);
        }
    }

    private void importEndemicSlice(String endemicSliceClassName) {
        this.endemicSliceList.add(this.loadEndemicSlice(endemicSliceClassName));
    }

    private EndemicSlice loadEndemicSlice(String endemicSliceClassName) {
        Object o = this.loadClass(endemicSliceClassName);
        if (!(o instanceof EndemicSlice) || o == null) {
            throw new RuntimeException("could not load endemic slice " + endemicSliceClassName);
        }
        EndemicSlice s = (EndemicSlice)o;
        return s;
    }

    public List<EndemicSlice> getEndemicSlices() {
        return Collections.unmodifiableList(this.endemicSliceList);
    }

    public Map<String, ModuleInterface> getSlices() {
        return Collections.unmodifiableMap(this.classSliceMap);
    }

    public ModuleInterface getSlice(String sliceName) {
        return this.classSliceMap.get(sliceName);
    }

    protected Rename rename(String to, String ... from) {
        return new Rename(to, from);
    }

    protected void declare(Rename ... renames) {
        this.renames.addAll(Arrays.asList(renames));
        for (Rename r : renames) {
            for (String from : r.from) {
                this.renameMap.put(from, r.to);
            }
        }
    }

    public Map<String, String> getRenames() {
        return this.renameMap;
    }

    protected static Map<String, ModuleInterface> initMap() {
        if (USE_ORDERED_HASHMAP) {
            return new LinkedHashMap<String, ModuleInterface>();
        }
        return new HashMap<String, ModuleInterface>();
    }
}

