/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection.dsl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import neverlang.examples.java.JavaMicroDA;
import neverlang.reflection.BinaryPattern;
import neverlang.reflection.HookType;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.PatternFilter;
import neverlang.reflection.ProductionPattern;
import neverlang.reflection.dsl.AgentCode;
import neverlang.runtime.dexter.ASTNode;

public class BeforeAfterAgentCode
extends AgentCode {
    private final ITreePattern pattern;
    private final HookType htype;
    private final PatternFilter patternFilter;
    private static final String TEMPLATE = "\n    @Override\n    public void {0}(IPatternMatch __pm) throws RemoteException '{'\n{1}\n        {2}\n    '}'\n";

    public BeforeAfterAgentCode(ITreePattern pattern, String code, HookType htype, PatternFilter filter) {
        super(code);
        this.pattern = pattern;
        this.htype = htype;
        this.patternFilter = filter;
    }

    private List<String> _getNodeInfoDeclarations(ITreePattern patt, List<String> decls) {
        if (patt == null) {
            return decls;
        }
        if (patt instanceof BinaryPattern) {
            BinaryPattern bpatt = (BinaryPattern)patt;
            decls = this._getNodeInfoDeclarations(bpatt.getLeft(), decls);
            decls = this._getNodeInfoDeclarations(bpatt.getRight(), decls);
        } else if (patt instanceof ProductionPattern) {
            String id = patt.getId();
            decls.add(String.format("        NodeInfo[] %s = __pm.getNodesInfo(\"%s\");\n", id, id));
        } else {
            String id = patt.getId();
            decls.add(String.format("        NodeInfo %s = __pm.getNodeInfo(\"%s\");\n", id, id));
        }
        return decls;
    }

    private String getNodeInfoDeclarations() {
        List<String> list = this._getNodeInfoDeclarations(this.pattern, new ArrayList<String>());
        return String.join((CharSequence)"\n", list);
    }

    @Override
    public String translate() {
        String finalCode = this.code;
        if (!this.code.trim().isEmpty()) {
            JavaMicroDA jmda = new JavaMicroDA();
            ASTNode root = jmda.exec(this.code);
            finalCode = (String)root.getValue("value");
        }
        String nodeInfoDeclarations = this.getNodeInfoDeclarations();
        String methodName = this.getHookType() == HookType.BEFORE ? "before" : "after";
        return MessageFormat.format(TEMPLATE, methodName, nodeInfoDeclarations, finalCode);
    }

    public String getCode() {
        return this.code;
    }

    public ITreePattern getPattern() {
        return this.pattern;
    }

    public HookType getHookType() {
        return this.htype;
    }

    public PatternFilter getPatternFilter() {
        return this.patternFilter;
    }
}

