/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection.dsl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import neverlang.reflection.AttributeValue;
import neverlang.reflection.BinaryPattern;
import neverlang.reflection.HookType;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.PatternFilter;
import neverlang.reflection.TreePattern;
import neverlang.reflection.dsl.AgentCode;
import neverlang.reflection.dsl.BeforeAfterAgentCode;
import neverlang.reflection.dsl.IDeclaration;
import neverlang.reflection.dsl.InterpreterChangedAgentCode;
import neverlang.reflection.dsl.PatternTranslator;
import neverlang.reflection.dsl.SymbolTable;
import neverlang.reflection.dsl.SystemWideAgentCode;
import neverlang.utils.Tuple;

public class AgentTemplate {
    private static final String INTERPRETER_VAR_NAME = "interpreter";
    private static final String imports = "import java.rmi.NotBoundException;\nimport java.rmi.RemoteException;\nimport java.util.Arrays;\nimport java.util.HashSet;\nimport neverlang.reflection.UnregisterAgentException;\nimport neverlang.reflection.AttributeValue;\nimport neverlang.reflection.HookType;\nimport neverlang.reflection.NodeInfo;\nimport neverlang.reflection.EndemicSliceInfo;\nimport neverlang.reflection.SliceInfo;\nimport neverlang.reflection.ActionInfo;\nimport neverlang.reflection.PatternFilter;\nimport neverlang.reflection.Agent;\nimport neverlang.reflection.OpenNeverlang;\nimport neverlang.reflection.IPatternMatch;\nimport neverlang.reflection.PrecedesPattern;\nimport neverlang.reflection.ChildPattern;\nimport neverlang.reflection.ITreePattern;\nimport neverlang.reflection.NonterminalPattern;\nimport neverlang.reflection.ProductionPattern;\n\n";
    private static final String registerTemplate = "        {2}.registerAgent(agent, {0}, role, {1});\n";
    private static final String classTemplate = "public class {0} extends Agent '{'\n    {1}\n\n    public {0}(OpenNeverlang openNeverlang) '{'\n        super(openNeverlang);\n    '}'\n\n    public static void main(String[] args) throws RemoteException, NotBoundException '{'\n        OpenNeverlang {2} = init(args);\n        if ({2} == null) '{'\n            System.out.println(\"Error connecting to the interpreter instance.\");\n            System.exit(1);\n        '}'\n\n        String role = args[1];\n        {0} agent = new {0}({2});\n\n{3}\n{4}\n{5}\n        agent.systemWide();\n    '}'\n    {6}\n'}'";
    private final String pack;
    private final String agentName;
    private final Collection<String> manualImports;
    private final SymbolTable symbolTable;
    private final List<AgentCode> agentCodes;

    public AgentTemplate(String agentName, List<AgentCode> agentCodes, Collection<String> imports, SymbolTable symbolTable) {
        List<String> split = Arrays.asList(agentName.split("\\."));
        if (split.size() == 1) {
            this.pack = "";
            this.agentName = agentName;
        } else {
            this.pack = String.join((CharSequence)".", split.subList(0, split.size() - 1));
            this.agentName = split.get(split.size() - 1);
        }
        this.manualImports = imports;
        this.agentCodes = agentCodes;
        this.symbolTable = symbolTable;
    }

    public void writeToFile() throws IOException {
        String folder = this.pack.replace('.', '/');
        if (folder.trim().isEmpty()) {
            folder = ".";
        }
        String fullPath = folder + "/" + this.agentName + ".java";
        File f = new File(folder);
        f.mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullPath), "utf-8"));){
            writer.write(this.translate());
        }
        System.out.println("Agent generated in: " + fullPath);
    }

    public String translateAttributeConstraints(TreePattern pp) {
        if (pp == null || pp instanceof BinaryPattern) {
            return "new HashSet()";
        }
        StringBuilder attrSb = new StringBuilder();
        boolean first = true;
        for (AttributeValue attrValue : pp.getAttributes()) {
            if (!first) {
                attrSb.append(", ");
            } else {
                first = false;
            }
            String value = attrValue.getValue() instanceof String ? String.format("\"%s\"", attrValue.getValue()) : attrValue.getValue().toString();
            attrSb.append(String.format("new AttributeValue(\"%s\", %s)", attrValue.getName(), value));
        }
        return attrSb.toString();
    }

    public String translate() {
        boolean bl;
        String pkg = this.pack.isEmpty() ? "" : "package " + this.pack + ";\n\n";
        StringBuilder sbImports = new StringBuilder();
        for (String string : this.manualImports) {
            sbImports.append(String.format("import %s;\n", string));
        }
        StringBuilder sbDeclarations = new StringBuilder();
        for (String id : this.symbolTable.getSymbols()) {
            IDeclaration decl = this.symbolTable.getSymbol(id);
            String declString = this.symbolTable.getSymbol(id).getDeclarationString();
            if (declString == null) continue;
            sbDeclarations.append("\t\t");
            sbDeclarations.append(declString);
            sbDeclarations.append("\n");
        }
        boolean bl2 = false;
        boolean afterDefined = false;
        boolean systemWideDefined = false;
        boolean ifChangedDefined = false;
        StringBuilder patterns = new StringBuilder();
        StringBuilder registrations = new StringBuilder();
        StringBuilder filters = new StringBuilder();
        StringBuilder codes = new StringBuilder();
        for (AgentCode acode : this.agentCodes) {
            if (acode instanceof BeforeAfterAgentCode) {
                HookType htype = ((BeforeAfterAgentCode)acode).getHookType();
                if (htype == HookType.BEFORE) {
                    bl = true;
                }
                if (htype == HookType.AFTER) {
                    afterDefined = true;
                }
                ITreePattern patt = ((BeforeAfterAgentCode)acode).getPattern();
                PatternFilter filter = ((BeforeAfterAgentCode)acode).getPatternFilter();
                Tuple<String, String> pattTranslation = PatternTranslator.translate(patt);
                patterns.append((String)pattTranslation.y);
                String filterTranslation = filter.translate((String)pattTranslation.x);
                filters.append(filterTranslation);
                registrations.append(MessageFormat.format(registerTemplate, new Object[]{pattTranslation.x, htype, INTERPRETER_VAR_NAME}));
            } else if (acode instanceof SystemWideAgentCode) {
                systemWideDefined = true;
            } else if (acode instanceof InterpreterChangedAgentCode) {
                ifChangedDefined = true;
            }
            codes.append(acode.translate());
            codes.append("\n");
        }
        if (!bl) {
            codes.append(new BeforeAfterAgentCode(null, "", HookType.BEFORE, new PatternFilter()).translate());
        }
        if (!afterDefined) {
            codes.append(new BeforeAfterAgentCode(null, "", HookType.AFTER, new PatternFilter()).translate());
        }
        if (!systemWideDefined) {
            codes.append(new SystemWideAgentCode("").translate());
        }
        if (!ifChangedDefined) {
            codes.append(new InterpreterChangedAgentCode("").translate());
        }
        return pkg + imports + sbImports.toString() + "\n\n" + MessageFormat.format(classTemplate, this.agentName, sbDeclarations.toString(), INTERPRETER_VAR_NAME, patterns.toString(), filters.toString(), registrations.toString(), codes.toString());
    }

    public static String translate(String agentName, ITreePattern pattern, HookType htype, String before, String after) {
        Tuple<String, String> patternTranslation = PatternTranslator.translate(pattern);
        return "import java.rmi.NotBoundException;\nimport java.rmi.RemoteException;\nimport java.util.Arrays;\nimport java.util.HashSet;\nimport neverlang.reflection.UnregisterAgentException;\nimport neverlang.reflection.AttributeValue;\nimport neverlang.reflection.HookType;\nimport neverlang.reflection.NodeInfo;\nimport neverlang.reflection.EndemicSliceInfo;\nimport neverlang.reflection.SliceInfo;\nimport neverlang.reflection.ActionInfo;\nimport neverlang.reflection.PatternFilter;\nimport neverlang.reflection.Agent;\nimport neverlang.reflection.OpenNeverlang;\nimport neverlang.reflection.IPatternMatch;\nimport neverlang.reflection.PrecedesPattern;\nimport neverlang.reflection.ChildPattern;\nimport neverlang.reflection.ITreePattern;\nimport neverlang.reflection.NonterminalPattern;\nimport neverlang.reflection.ProductionPattern;\n\n\n" + MessageFormat.format(classTemplate, agentName, patternTranslation.y, patternTranslation.x, htype.toString(), before, after);
    }

    public static void main(String[] args) {
    }
}

