/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.util.Collection;
import java.util.Iterator;
import neverlang.reflection.AttributeValue;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.PatternMatch;
import neverlang.runtime.dexter.ASTNode;

public class ProductionPatternMatch
extends PatternMatch {
    private final Collection<ASTNode> nodes;
    private final String id;

    public ProductionPatternMatch(ITreePattern pattern, Collection<ASTNode> nodes, String id) {
        super(pattern);
        this.nodes = nodes;
        this.id = id;
    }

    @Override
    public Collection<ASTNode> getNodes() {
        return this.nodes;
    }

    public String toString() {
        Iterator<ASTNode> it = this.nodes.iterator();
        ASTNode root = it.next();
        return String.format("P(id=%s, term=%s)", this.id, root.toTerminalString());
    }

    @Override
    public boolean dynamicConstraints() {
        Collection<AttributeValue> attributeConstraints = this.getPattern().getAttributeConstraints();
        for (ASTNode node : this.nodes) {
            if (this.attributeConstrainsHold(attributeConstraints, node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeInfo[] getNodesInfo(String id) {
        ITreePattern pattern = this.getPattern();
        if (pattern.getId().equals(id)) {
            int i = 0;
            NodeInfo[] nodeInfo = new NodeInfo[this.nodes.size()];
            for (ASTNode node : this.nodes) {
                nodeInfo[i++] = node.toNodeInfo();
            }
            return nodeInfo;
        }
        return null;
    }

    @Override
    public NodeInfo getNodeInfo(String patternId) {
        throw new UnsupportedOperationException("Should call getNodeInfo instead. You've hit a bug in your code. :(\n\nIf the code was automatically generated, then please check your code generation tool.");
    }
}

