/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import dexter.grammar.Production;
import dexter.grammar.TerminalSym;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import neverlang.reflection.ActionInfo;
import neverlang.reflection.AnyPattern;
import neverlang.reflection.HookType;
import neverlang.reflection.IAgent;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.ITreePattern;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.NonterminalPatternMatch;
import neverlang.reflection.PatternFilter;
import neverlang.reflection.PatternMatch;
import neverlang.reflection.ProductionInfo;
import neverlang.reflection.RoleInfo;
import neverlang.runtime.Context;
import neverlang.runtime.Language;
import neverlang.runtime.Module;
import neverlang.runtime.ModuleInterface;
import neverlang.runtime.Role;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.dexter.ASTNode;
import neverlang.utils.ClassHelper;
import neverlang.utils.Tuple;

public class OpenLanguage
extends Language {
    List<IAgent> agents = new ArrayList<IAgent>();
    private Context currentContext = null;

    @Override
    protected void preorder(Context ctx) {
        try {
            this.currentContext = ctx;
            ctx.node().beforeHook(ctx);
        }
        catch (RemoteException ex) {
            Logger.getLogger(OpenLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.preorder(ctx);
        try {
            this.currentContext = ctx;
            ctx.node().afterHook(ctx);
        }
        catch (RemoteException ex) {
            Logger.getLogger(OpenLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void postorder(Context ctx) {
        try {
            this.currentContext = ctx;
            ctx.node().beforeHook(ctx);
        }
        catch (RemoteException ex) {
            Logger.getLogger(OpenLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.postorder(ctx);
        try {
            this.currentContext = ctx;
            ctx.node().afterHook(ctx);
        }
        catch (RemoteException ex) {
            Logger.getLogger(OpenLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void printNodes(Collection<ASTNode> nodes) {
        for (ASTNode n : nodes) {
            System.out.println(n.getProduction());
        }
    }

    private void printPatternMatches(Collection<PatternMatch> pmatches) {
        for (PatternMatch pm : pmatches) {
            System.out.println(pm);
        }
    }

    private boolean addNode(Collection<ASTNode> collectedNodes, ASTNode node) {
        for (ASTNode n : collectedNodes) {
            if (n != node) continue;
            return false;
        }
        return collectedNodes.add(node);
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    private Collection<IPatternMatch> _getPatternMatches(Context ctx, ITreePattern pattern, Collection<IPatternMatch> collectedPMC) {
        ASTNode n = ctx.node();
        if (n.getSymbol() instanceof TerminalSym) {
            return collectedPMC;
        }
        if (n.productionPos == -1) {
            Production p = n.getProduction();
            n.productionPos = this.getProductionPos(p);
        }
        int start = n.productionPos;
        ctx.setOffset(start);
        pattern.resetMatches();
        if (pattern.matches(ctx)) {
            Collection<IPatternMatch> matches = pattern.getMatches();
            collectedPMC.addAll(pattern.getMatches());
        }
        for (ASTNode ch : n.ntchildren) {
            collectedPMC = this._getPatternMatches(ctx.derive(ch), pattern, collectedPMC);
        }
        pattern.resetMatches();
        return collectedPMC;
    }

    private Collection<IPatternMatch> getPatternMatches(Context ctx, ITreePattern pattern) {
        ArrayList<IPatternMatch> collectedPMC = new ArrayList<IPatternMatch>();
        return this._getPatternMatches(ctx, pattern, collectedPMC);
    }

    public void registerAgent(IAgent agent, ITreePattern pattern, String roleName, HookType htype) throws RemoteException {
        ASTNode tree = this.getLastParseTree();
        if (tree == null) {
            System.err.println("Agent registration failed. There is no program running.");
            return;
        }
        Role role2 = this.getRoleByName(roleName);
        if (role2 == null) {
            throw new RemoteException("No role named " + roleName);
        }
        if (pattern instanceof AnyPattern) {
            this.registerAgentAtEveryNode(pattern, tree, agent, htype);
            return;
        }
        Context ctx = new Context(tree, tree, this, role2, 0);
        pattern.init(ctx);
        Collection<IPatternMatch> collectedPMs = this.getPatternMatches(ctx, pattern);
        PatternFilter filter = pattern.getPatternFilter();
        for (IPatternMatch pm : collectedPMs) {
            block6: for (String id : pm.getPattern().getIds()) {
                if (filter != null && !filter.shouldRegister(id)) continue;
                NodeInfo nodeInfo = pm.getNodeInfo(id);
                ASTNode n = ASTNode.getNodeByRmiHandle(nodeInfo.getRmiHandle());
                switch (htype) {
                    case BEFORE: {
                        n.registerAgentBefore(agent, pm);
                        continue block6;
                    }
                    case AFTER: {
                        n.registerAgentAfter(agent, pm);
                        continue block6;
                    }
                    case BEFORE_AND_AFTER: {
                        n.registerAgentAfter(agent, pm);
                        n.registerAgentBefore(agent, pm);
                        continue block6;
                    }
                }
                throw new AssertionError((Object)htype.name());
            }
        }
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
    }

    public ProductionInfo getCurrentProduction() throws RemoteException {
        if (this.currentContext == null) {
            throw new RemoteException("There's nothing running ...");
        }
        return new ProductionInfo(this.currentContext.node().getProduction());
    }

    public RoleInfo[] getRoleInfos() {
        ArrayList<RoleInfo> roleInfos = new ArrayList<RoleInfo>();
        for (Role role2 : this.getRoles()) {
            roleInfos.add(new RoleInfo(role2));
        }
        return roleInfos.toArray(new RoleInfo[0]);
    }

    public ProductionInfo[] getGrammar() {
        ArrayList<ProductionInfo> res = new ArrayList<ProductionInfo>();
        for (ModuleInterface m : this.classSliceMap.values()) {
            Production[] syntax2;
            for (Production p : syntax2 = m.getSyntax()) {
                res.add(new ProductionInfo(p));
            }
        }
        return (ProductionInfo[])res.toArray();
    }

    public NodeInfo getCurrentNode() throws RemoteException {
        if (this.currentContext == null) {
            throw new RemoteException("There's nothing running ...");
        }
        ASTNode node = this.currentContext.node();
        return new NodeInfo(node);
    }

    public void replaceSlice(String oldSlice, String newSlice) {
        ModuleInterface removedSlice;
        if (this.productionToSlice.isEmpty()) {
            this.loadSyntax();
        }
        if ((removedSlice = this.removeSlice(oldSlice)) == null) {
            throw new RuntimeException("Slice: " + oldSlice + " was not removed. Please verify that the slice exists!");
        }
        for (Production p : removedSlice.getSyntax()) {
            ModuleInterface moduleInterface = (ModuleInterface)this.productionToSlice.remove(p);
        }
        ModuleInterface sl = this.importSlice(newSlice);
        this.remapSlices(removedSlice, sl);
        sl.getSyntaxRole();
        this.invalidateCache();
    }

    private void remapSlices(ModuleInterface oldSlice, ModuleInterface newSlice) {
        for (Production p : oldSlice.getSyntax()) {
            ModuleInterface moduleInterface = this.productionToSlice.put(p, newSlice);
        }
    }

    public void redoRole(String roleName) {
        ASTNode lastParseTree = this.getLastParseTree();
        Role role2 = this.getRoleByName(roleName);
        int roleId = this.getRoleId(role2);
        this.eval(new Context(lastParseTree, lastParseTree, this, role2, roleId));
    }

    public void addActionToNode(ActionInfo actionInfo, NodeInfo nodeInfo, String addToRole) throws RemoteException {
        Tuple<SemanticAction, ASTNode> actionAndNode = this.getActionAndNode(actionInfo, nodeInfo);
        ASTNode node = (ASTNode)actionAndNode.y;
        SemanticAction action = (SemanticAction)actionAndNode.x;
        node.addAction(action, this.getRoleId(this.getRoleByName(addToRole)));
    }

    public void removeActionFromNode(ActionInfo actionInfo, NodeInfo nodeInfo, String fromRole) throws RemoteException {
        Tuple<SemanticAction, ASTNode> actionAndNode = this.getActionAndNode(actionInfo, nodeInfo);
        ASTNode node = (ASTNode)actionAndNode.y;
        SemanticAction action = (SemanticAction)actionAndNode.x;
        node.removeAction(action, this.getRoleId(this.getRoleByName(fromRole)));
    }

    public void setDefaultAction(ActionInfo actionInfo, NodeInfo nodeInfo, String roleName) throws RemoteException {
        Tuple<SemanticAction, ASTNode> actionAndNode = this.getActionAndNode(actionInfo, nodeInfo);
        ASTNode node = (ASTNode)actionAndNode.y;
        SemanticAction action = (SemanticAction)actionAndNode.x;
        Role roleByName = this.getRoleByName(roleName);
        node.setDefaultAction(action, this.currentContext, roleByName);
    }

    private Tuple<SemanticAction, ASTNode> getActionAndNode(ActionInfo actionInfo, NodeInfo nodeInfo) throws RemoteException {
        Module mod = (Module)ClassHelper.instantiateClass(actionInfo.getModule());
        SemanticAction action = actionInfo.getLabel() != null ? mod.getAction(actionInfo.getRole(), actionInfo.getLabel()) : mod.getAction(actionInfo.getRole(), actionInfo.getPos());
        if (action == null) {
            throw new RemoteException("Action described by ActionInfo is null.");
        }
        ASTNode node = ASTNode.getNodeByRmiHandle(nodeInfo.getRmiHandle());
        if (node == null) {
            throw new RemoteException("Node described by NodeInfo is null");
        }
        return new Tuple<SemanticAction, ASTNode>(action, node);
    }

    private void registerAgentAtEveryNode(ITreePattern pattern, ASTNode node, IAgent agent, HookType htype) {
        NonterminalPatternMatch pm = new NonterminalPatternMatch(pattern, node, "_");
        switch (htype) {
            case BEFORE: {
                node.registerAgentBefore(agent, pm);
                break;
            }
            case AFTER: {
                node.registerAgentAfter(agent, pm);
                break;
            }
            case BEFORE_AND_AFTER: {
                node.registerAgentAfter(agent, pm);
                node.registerAgentBefore(agent, pm);
                break;
            }
            default: {
                throw new AssertionError((Object)htype.name());
            }
        }
        for (ASTNode ch : node.ntchildren) {
            this.registerAgentAtEveryNode(pattern, ch, agent, htype);
        }
    }
}

