/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.io.File;
import java.io.Serializable;
import neverlang.runtime.dexter.ASTNode;

public class NodeInfo
implements Serializable {
    private final String nodeString;
    private final String terminalString;
    private final String rmiHandle;
    private final File file;
    private final int line;
    private final boolean isExecutionStep;

    public NodeInfo(ASTNode node) {
        this.nodeString = node.toString();
        this.terminalString = node.toTerminalString();
        this.rmiHandle = node.getRmiHandle();
        this.file = node.getFile();
        this.line = this.getLine(node);
        this.isExecutionStep = (Boolean)node.getValues().getOrDefault("isExecutionStep", false);
    }

    private int getLine(ASTNode node) {
        if (node.token != null) {
            return node.token.row;
        }
        if (node.children().length == 0) {
            return 0;
        }
        return this.getLine(node.child(0));
    }

    public File getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isExecutionStep() {
        return this.isExecutionStep;
    }

    public String terminalString() {
        return this.terminalString;
    }

    public String toString() {
        return this.nodeString;
    }

    public String getRmiHandle() {
        return this.rmiHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return this.rmiHandle.equals(nodeInfo.rmiHandle);
    }

    public int hashCode() {
        return this.rmiHandle.hashCode();
    }
}

