/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Scanner;
import neverlang.reflection.Agent;
import neverlang.reflection.AnyPattern;
import neverlang.reflection.HookType;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.NodeInfo;
import neverlang.reflection.OpenNeverlang;

public class NeverlangDebugger
extends Agent {
    public NeverlangDebugger(OpenNeverlang openNeverlang) {
        super(openNeverlang);
    }

    public static void main(String[] args) throws RemoteException, NotBoundException {
        OpenNeverlang interpreter = NeverlangDebugger.init(args);
        if (interpreter == null) {
            System.out.println("Error connecting to the interpreter instance.");
            System.exit(1);
        }
        String role2 = args[1];
        NeverlangDebugger agent = new NeverlangDebugger(interpreter);
        AnyPattern pattern = new AnyPattern();
        interpreter.registerAgent(agent, pattern, role2, HookType.BEFORE);
        interpreter.registerAgent(agent, pattern, role2, HookType.AFTER);
    }

    private void prompt() {
        System.out.println(">");
    }

    private void readInput() throws RemoteException {
        String input;
        Scanner scanner = new Scanner(System.in);
        switch (input = scanner.nextLine().trim().toLowerCase()) {
            case "current": {
                System.out.println(this.interpreter.getCurrentNode());
                break;
            }
        }
    }

    @Override
    public void before(IPatternMatch pm) throws RemoteException {
        NodeInfo currentNode = this.interpreter.getCurrentNode();
        this.prompt();
        this.readInput();
    }

    @Override
    public void after(IPatternMatch pm) throws RemoteException {
        NodeInfo currentNode = this.interpreter.getCurrentNode();
        System.out.println("After: " + currentNode.terminalString());
    }

    @Override
    public void interpreterChanged() throws RemoteException {
    }
}

