/*
 * Decompiled with CFR 0.152.
 */
package neverlang.reflection;

import java.util.Collection;
import neverlang.reflection.BinaryPattern;
import neverlang.reflection.BinaryPatternMatch;
import neverlang.reflection.IPatternMatch;
import neverlang.reflection.ITreePattern;
import neverlang.runtime.Context;
import neverlang.runtime.dexter.ASTNode;

public class ChildPattern
extends BinaryPattern {
    public ChildPattern(ITreePattern left, ITreePattern right) {
        super(left, right);
    }

    @Override
    public boolean matches(Context ctx) {
        ASTNode node = ctx.node();
        if (this.left.matches(ctx)) {
            boolean matched = false;
            for (ASTNode ch : node.ntchildren) {
                if (!this.right.matches(ctx.derive(ch))) continue;
                matched = true;
                Collection<IPatternMatch> leftMatches = this.left.getMatches();
                Collection<IPatternMatch> rightMatches = this.right.getMatches();
                IPatternMatch leftMatch = leftMatches.iterator().next();
                for (IPatternMatch rm : rightMatches) {
                    this.addMatch(new BinaryPatternMatch(this, leftMatch, rm));
                }
                this.right.resetMatches();
            }
            this.left.resetMatches();
            return matched;
        }
        this.left.resetMatches();
        return false;
    }

    public String toString() {
        return String.format("ChildPattern(%s, %s)", this.left.toString(), this.right.toString());
    }
}

