/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.syn.category;

import dexter.grammar.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Categories {
    private final Map<String, List<Symbol>> categoryToSymbols = new HashMap<String, List<Symbol>>();

    public void updateCategoryDefinition(String category, List<Symbol> symbols) {
        if (this.categoryToSymbols.containsKey(category)) {
            this.categoryToSymbols.get(category).addAll(symbols);
        } else {
            this.categoryToSymbols.put(category, new ArrayList<Symbol>(symbols));
        }
    }

    public void updateCategories(Map<String, List<Symbol>> declaredCategories) {
        for (String catName : declaredCategories.keySet()) {
            this.updateCategoryDefinition(catName, declaredCategories.get(catName));
        }
    }

    public String dump(String pack) {
        StringBuilder builder = new StringBuilder();
        if (!pack.isEmpty()) {
            builder.append(String.format("package %s;\n\n", pack));
        }
        builder.append("import java.util.HashMap;\n").append("import java.util.Map;\n\n").append("public final class CategoryMapper {\n").append("\tpublic static final Map<Integer, String> mapper;\n").append("\tstatic {\n").append("\t\tmapper = new HashMap<Integer, String>();\n");
        for (String category : this.categoryToSymbols.keySet()) {
            List<Symbol> symbols = this.categoryToSymbols.get(category);
            for (Symbol s : symbols) {
                builder.append("\t\tmapper.put(" + s.hashCode() + ", \"" + category + "\");\n");
            }
        }
        builder.append("\t};\n").append("}\n");
        return builder.toString();
    }

    public String getFilename() {
        return "CategoryMapper";
    }
}

