/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.slc;

import dexter.grammar.Production;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.compiler.syn.SyntaxRoleSource;
import neverlang.runtime.Module;
import neverlang.runtime.NonterminalMapping;
import neverlang.runtime.RoleDef;
import neverlang.runtime.Slice;
import neverlang.utils.StringUtils;

public class SliceSource
extends Slice {
    private String tpl = "%s\nimport neverlang.runtime.*;\npublic class %s extends Slice {\n  public %s() {\n%s    %s\n  }\n\n  %s\n}\n";
    private String[] tags = new String[0];

    public void setCanonicalName(String str) {
        int start;
        int endpkg = start = str.lastIndexOf(".");
        if (start < 0) {
            start = 0;
            endpkg = 0;
        } else {
            ++start;
        }
        this.name = str.substring(start);
        this.pkgName = str.substring(0, endpkg);
        this.className = str;
    }

    public void setPackageName(String pkg) {
        this.pkgName = pkg;
        this.className = this.pkgName + "." + this.name;
    }

    public void setSyntax(String mname) {
        SyntaxRoleSource synsrc = new SyntaxRoleSource();
        synsrc.setModuleName(mname);
        this.syntax = synsrc;
    }

    public void addRoles(String mname, List<RoleDef> roles) {
        ModuleSource m = new ModuleSource();
        m.setCanonicalName(mname);
        this.moduleInstanceMap.put(m.getCanonicalName(), m);
        for (RoleDef r : roles) {
            m.addRole(r.getName());
            this.addRoleDef(r);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String syntaxModule = this.syntax == null ? null : ((SyntaxRoleSource)this.syntax).getModuleName();
        for (String mname : this.moduleInstanceMap.keySet()) {
            Set roles = ((Module)this.moduleInstanceMap.get(mname)).getRoleMap().keySet();
            if (roles.contains("syntax")) {
                roles.remove("syntax");
                syntaxModule = mname;
            }
            if (roles.isEmpty()) continue;
            sb.append("    imports(\"");
            sb.append(mname);
            sb.append("\"");
            for (String roleName : roles) {
                sb.append(", \n         role(\"");
                sb.append(roleName);
                sb.append("\")");
                RoleDef r = (RoleDef)this.roledefMap.get(roleName);
                if (r == null) continue;
                NonterminalMapping ntMap = r.getMapping();
                for (Integer mappedValue : ntMap.getMappedValues()) {
                    sb.append(".remap(").append(mappedValue).append(", ").append(ntMap.image(mappedValue)).append(")");
                }
            }
            sb.append(");\n");
        }
        String tagString = this.getTags().length > 0 ? String.format("public String[] getTags() {\n    return new String[] { \"%s\" };\n  }\n", StringUtils.join(Arrays.asList(this.getTags()), "\", \"")) : "";
        return String.format(this.tpl, this.packageString(), this.getName(), this.getName(), this.syntaxString(syntaxModule), sb.toString(), tagString);
    }

    private String packageString() {
        return this.pkgName.isEmpty() ? "" : "package " + this.pkgName + ";";
    }

    private String syntaxString(String s) {
        if (s == null) {
            return "";
        }
        return "    importSyntax(\"" + s + "\");\n";
    }

    private void addRoleDef(RoleDef r) {
        this.roledefMap.put(r.getName(), r);
    }

    @Override
    public int getProductionPos(Production p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTags(List<String> tags) {
        this.tags = tags.toArray(this.tags);
    }

    @Override
    public String[] getTags() {
        HashSet<String> sliceTags = new HashSet<String>();
        sliceTags.addAll(Arrays.asList(this.tags));
        for (String module : this.getModules()) {
            Module m = this.getModule(module);
            sliceTags.addAll(Arrays.asList(m.getTags()));
        }
        return sliceTags.toArray(new String[0]);
    }
}

