/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.plugins.translator;

import dexter.grammar.Production;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import neverlang.compiler.mdl.ExceptionGuard;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.compiler.mdl.PredicateGuard;
import neverlang.compiler.mdl.TypeGuard;
import neverlang.runtime.Context;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.Syntax;
import neverlang.utils.Tuple;

public abstract class TranslatorPlugin
implements SemanticAction,
Comparable<Object> {
    protected String language;
    protected String fileExtension;
    protected String packageString;
    protected String importString;
    protected String fileTemplate;
    protected String rootAttributeWrite;
    protected String rootAttributeRead;
    protected String childAttributeWrite;
    protected String childAttributeRead;
    protected String rootReference;
    protected String childReference;
    protected String lexemeReference;
    protected String singletonRead;
    protected String evalStatement;
    protected String evalChildren;
    protected String evalReturn;
    protected String suspendStatement;
    protected String resumeStatement;
    protected String terminateStatement;
    protected String setDefaultAction;
    protected boolean defaultLanguage = false;
    protected boolean shouldEvalChildren = false;
    protected boolean isSingleAction = true;
    protected String[] defaultImports = new String[]{"dexter.lexter.QualifiedToken", "neverlang.runtime.*", "neverlang.runtime.dexter.ASTNode", "neverlang.runtime.dexter.UndefinedAttributeException"};
    String fileNameTemplate = "{0}$role${1}${2,number,integer}{3}{4}";
    protected String src;
    protected String mname;
    protected String rolename;
    protected String nameSuffix = "";
    ExceptionGuard exceptionAnnotation = null;
    PredicateGuard predicate = null;
    private int actionID;
    private String label;
    int priority = Integer.MIN_VALUE;
    protected int pos = -1;
    final String id = "\\$(\\d+)";
    protected final String nonterminal = "\\$(\\d+)\\.(\\w+)";
    final String nonterminalAndEval = "\\$(\\d+):(\\w+)";
    final String terminal = "#(\\d+)";
    final String eval = "eval\\s+(\\$(\\d+));";
    final String suspendStmt = "\\$suspend;";
    final String resumeStmt = "\\$resume;";
    final String terminateStmt = "\\$terminate;";
    final String singleton = "\\$\\$([a-zA-Z]+)";
    Pattern assignment = Pattern.compile("\\$(\\d+)\\.(\\w+)\\s*=([^;]+);");
    Pattern access = Pattern.compile("\\$(\\d+)\\.(\\w+)");
    Pattern accessAndEval = Pattern.compile("\\$(\\d+):(\\w+)");
    Pattern identifier = Pattern.compile("\\$(\\d+)");
    Pattern terminalId = Pattern.compile("#(\\d+)");
    Pattern singletonP = Pattern.compile("\\$\\$([a-zA-Z]+)");
    Pattern evalStmtP = Pattern.compile("eval\\s+(\\$(\\d+));");
    Pattern suspend = Pattern.compile("\\$suspend;");
    Pattern resume = Pattern.compile("\\$resume;");
    Pattern terminate = Pattern.compile("\\$terminate;");
    protected String cname;
    protected ModuleSource module;
    protected int ruleindex = -1;
    protected Set<String> requiredSingletons = new HashSet<String>();

    public String getSource() {
        return this.src;
    }

    public ModuleSource getModule() {
        return this.module;
    }

    private void addEndemicSlice(String name) {
        this.requiredSingletons.add(name);
    }

    private String injectCasts(String src) {
        if (!(this.predicate instanceof TypeGuard)) {
            throw new RuntimeException("TranslatorPlugin.injectCasts(...) called on an action not guarded by the TypeGuard!");
        }
        TypeGuard guard = (TypeGuard)this.predicate;
        List<Tuple<String, String>> constraints = guard.getConstraints();
        StringBuilder sb = new StringBuilder();
        src = this.replaceLabels(src);
        String newStr = src = this.replaceMatches(src, this.assignment, Phase.ASSIGN);
        Matcher matcher = this.access.matcher(newStr);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String matched = matchResult.group(0);
            for (Tuple<String, String> constr : constraints) {
                String constrFinal = this.replaceMatches(this.replaceLabels((String)constr.x), this.assignment, Phase.ASSIGN);
                if (!constrFinal.equals(matched)) continue;
                String replacement = String.format("(%s)%s", constr.y, constrFinal);
                sb.append(String.format("%s%s", newStr.substring(0, matchResult.start()), replacement));
                newStr = newStr.substring(matchResult.end());
                matcher.reset(newStr);
                break;
            }
            matcher.reset(newStr);
        }
        sb.append(newStr);
        return sb.toString();
    }

    public boolean isDefaultLanguage() {
        return this.defaultLanguage;
    }

    public boolean shouldEvalChildren() {
        return this.shouldEvalChildren;
    }

    public void setShouldEvalChildren(boolean prop) {
        this.shouldEvalChildren = prop;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSource(String src) {
        this.src = src;
    }

    public void setRoleName(String rolename) {
        this.rolename = rolename;
    }

    public String getRoleName() {
        return this.rolename;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public String[] getEndemicSlices() {
        return this.requiredSingletons.toArray(new String[0]);
    }

    public int getPos() {
        return this.pos;
    }

    protected int getRuleIndex() {
        if (this.ruleindex < 0) {
            throw new RuntimeException("Invalid ruleindex " + this.ruleindex + ". Did you set a parent Module?");
        }
        return this.ruleindex;
    }

    public void setRuleIndex(int idx) {
        this.ruleindex = idx;
    }

    public void setModule(ModuleSource m) {
        int i;
        if (m == null) {
            throw new RuntimeException("cannot set a null module");
        }
        int lastidx = 0;
        this.module = m;
        Production[] ps = this.module.getSyntax();
        if (ps.length == 0) {
            throw new RuntimeException("ERROR: No syntax for module " + m.getCanonicalName());
        }
        int idx = 0;
        neverlang.runtime.Production p = (neverlang.runtime.Production)ps[i];
        for (i = 0; idx < this.pos && i != ps.length; ++i) {
            lastidx = idx;
            idx = ((neverlang.runtime.Production)ps[i]).getIndex();
        }
        this.ruleindex = idx == this.pos ? idx : lastidx;
    }

    protected String formatPredicate(String src) {
        src = this.replaceLabels(src);
        src = this.replaceMatches(src, this.access, Phase.FIELD);
        src = this.replaceMatches(src, this.evalStmtP, Phase.EVAL);
        src = this.replaceMatches(src, this.singletonP, Phase.SINGLETON);
        src = this.replaceMatches(src, this.identifier, Phase.ID);
        src = this.replaceMatches(src, this.terminalId, Phase.TERMINAL);
        return src;
    }

    protected String formatSource(String src) {
        src = this.replaceLabels(src);
        src = this.replaceMatches(src, this.assignment, Phase.ASSIGN);
        src = this.replaceMatches(src, this.access, Phase.FIELD);
        src = this.replaceMatches(src, this.accessAndEval, Phase.FIELD_EVAL);
        src = this.replaceMatches(src, this.evalStmtP, Phase.EVAL);
        src = this.replaceMatches(src, this.singletonP, Phase.SINGLETON);
        src = this.replaceMatches(src, this.identifier, Phase.ID);
        src = this.replaceMatches(src, this.terminalId, Phase.TERMINAL);
        src = this.replaceMatches(src, this.suspend, Phase.SUSPEND);
        src = this.replaceMatches(src, this.resume, Phase.RESUME);
        src = this.replaceMatches(src, this.terminate, Phase.TERMINATE);
        if (this.shouldEvalChildren) {
            src = "    " + MessageFormat.format(this.evalChildren, this.getPos()) + "\n" + src;
        }
        return src;
    }

    protected String replaceFieldAssignments(MatchResult mr) {
        if (mr.group(1).equals(String.valueOf(this.getRuleIndex()))) {
            return this.rootAttributeWrite;
        }
        return this.childAttributeWrite;
    }

    protected String replaceFieldReads(MatchResult mr) {
        if (mr.group(1).equals(String.valueOf(this.getRuleIndex()))) {
            return this.rootAttributeRead;
        }
        return this.childAttributeRead;
    }

    protected String replaceFieldAndEval(MatchResult mr) {
        return this.evalReturn;
    }

    protected String replaceIdentifiers(MatchResult mr) {
        if (mr.group(1).equals(String.valueOf(this.getRuleIndex()))) {
            return this.rootReference;
        }
        return this.childReference;
    }

    protected String replaceTerminals(MatchResult mr) {
        return this.lexemeReference;
    }

    protected String replaceEval(MatchResult mr) {
        return this.evalStatement;
    }

    protected String replaceSingleton(MatchResult mr) {
        return this.singletonRead;
    }

    protected String replaceMatches(String string, Pattern p, Phase replaceAssignments) {
        Matcher matcher = p.matcher(string);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String replacement = null;
            try {
                switch (replaceAssignments) {
                    case ASSIGN: {
                        replacement = MessageFormat.format(this.replaceFieldAssignments(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(2), matchResult.group(3));
                        break;
                    }
                    case FIELD: {
                        replacement = MessageFormat.format(this.replaceFieldReads(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(2));
                        break;
                    }
                    case FIELD_EVAL: {
                        replacement = MessageFormat.format(this.replaceFieldAndEval(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(2));
                        break;
                    }
                    case ID: {
                        replacement = MessageFormat.format(this.replaceIdentifiers(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(1));
                        break;
                    }
                    case TERMINAL: {
                        replacement = MessageFormat.format(this.replaceTerminals(matchResult), Integer.parseInt(matchResult.group(1)), matchResult.group(1));
                        break;
                    }
                    case EVAL: {
                        replacement = MessageFormat.format(this.replaceEval(matchResult), matchResult.group(1));
                        break;
                    }
                    case SINGLETON: {
                        replacement = MessageFormat.format(this.replaceSingleton(matchResult), matchResult.group(1));
                        this.addEndemicSlice(matchResult.group(1));
                        break;
                    }
                    case SUSPEND: {
                        replacement = this.suspendStatement;
                        break;
                    }
                    case RESUME: {
                        replacement = this.resumeStatement;
                        break;
                    }
                    case TERMINATE: {
                        replacement = this.terminateStatement;
                    }
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
            string = string.substring(0, matchResult.start()) + replacement + string.substring(matchResult.end());
            matcher.reset(string);
        }
        return string;
    }

    protected String replaceLabels(String string) {
        Production[] prods;
        Syntax syntax2 = this.module.getSyntaxRole();
        for (Production prod : prods = syntax2.getProductions()) {
            MatchResult matchResult;
            String plabel = prod.getLabel();
            if (plabel == null) continue;
            int prodpos = syntax2.getPos(prod);
            String regex = String.format("\\$\\b%s\\b\\[([0-9]+)\\]", plabel);
            Pattern lp = Pattern.compile(regex);
            Matcher matcher = lp.matcher(string);
            while (matcher.find()) {
                matchResult = matcher.toMatchResult();
                int offset = Integer.parseInt(matchResult.group(1));
                String replacement = String.format("$%d", prodpos + offset);
                string = string.substring(0, matchResult.start()) + replacement + string.substring(matchResult.end());
                matcher.reset(string);
            }
            regex = String.format("\\$\\b%s\\b", plabel);
            lp = Pattern.compile(regex);
            matcher = lp.matcher(string);
            while (matcher.find()) {
                matchResult = matcher.toMatchResult();
                String replacement = String.format("$%d", prodpos);
                string = string.substring(0, matchResult.start()) + replacement + string.substring(matchResult.end());
                matcher.reset(string);
            }
        }
        return string;
    }

    private int calcId(int dollarNotationValue) {
        return dollarNotationValue;
    }

    public String getPackageString() {
        return this.module.getPackageName().isEmpty() ? "" : MessageFormat.format(this.packageString, this.module.getPackageName()) + "\n";
    }

    public String getName() {
        String runOnSuffix = this.exceptionAnnotation == null ? "" : this.exceptionAnnotation.getException().replace('.', '_');
        String suffix = this.nameSuffix.isEmpty() || !runOnSuffix.isEmpty() ? "" : "_" + this.nameSuffix;
        return MessageFormat.format(this.fileNameTemplate, this.module.getName(), this.rolename, this.pos, runOnSuffix, suffix);
    }

    protected String preprocessImport(String importString) {
        return importString;
    }

    protected String formatImports(List<String> importList) {
        StringBuilder sb = new StringBuilder();
        MessageFormat mf = new MessageFormat(this.importString);
        Object[] args = new Object[1];
        for (String s : importList) {
            args[0] = this.preprocessImport(s);
            sb.append(mf.format(args));
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.defaultImports));
        list.addAll(this.module.getImports());
        String source = this.src;
        String pred = "return true;";
        int prio = PredicateGuard.LOWEST_PRIORITY;
        boolean softGuard = false;
        if (this.exceptionAnnotation != null) {
            pred = "return false;";
            prio = this.exceptionAnnotation.getPriority();
            softGuard = this.exceptionAnnotation.isPermanent();
        } else if (this.predicate != null) {
            pred = this.predicate.getPredicate();
            pred = this.replaceLabels(pred);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("try {return %s;} catch (UndefinedAttributeException e) { return false; }", pred));
            if (this.predicate instanceof TypeGuard) {
                source = this.injectCasts(this.src);
            }
            pred = this.formatPredicate(sb.toString());
            prio = this.predicate.getPriority();
            softGuard = this.predicate.isPermanent();
        }
        String _label = this.getLabel() == null ? "" : this.getLabel();
        return this.getPackageString() + this.formatImports(list) + MessageFormat.format(this.fileTemplate, this.getName(), this.shouldEvalChildren() ? "SemanticAction" : "PostorderSemanticAction", this.formatSource(source), pred, Long.toString(prio), String.valueOf(softGuard), _label, this.pos);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public boolean isSingleAction() {
        return this.isSingleAction;
    }

    public void isSingleAction(boolean single) {
        this.isSingleAction = single;
    }

    public String getSourceWithoutLabels() {
        return this.replaceLabels(this.getSource());
    }

    @Override
    public void apply(Context $ctx) {
        throw new UnsupportedOperationException();
    }

    public void setPredicate(PredicateGuard pred) {
        this.predicate = pred;
    }

    public PredicateGuard getPredicate() {
        return this.predicate;
    }

    public void setException(ExceptionGuard ae) {
        this.exceptionAnnotation = ae;
    }

    public ExceptionGuard getException() {
        return this.exceptionAnnotation;
    }

    public void setNameSuffix(String suff) {
        this.nameSuffix = suff;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setActionID(int id) {
        this.actionID = id;
    }

    public int getActionID() {
        return this.actionID;
    }

    public String getCleanName() {
        return MessageFormat.format(this.fileNameTemplate, this.module.getName(), this.rolename, this.pos, "", "");
    }

    @Override
    public int compareTo(Object o) {
        TranslatorPlugin tp = (TranslatorPlugin)o;
        if (this.getPriority() < tp.getPriority()) {
            return -1;
        }
        return 1;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public SemanticAction setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void setPriority(int prio) {
        this.priority = prio;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected static enum Phase {
        ASSIGN,
        FIELD,
        FIELD_EVAL,
        ID,
        TERMINAL,
        EVAL,
        SUSPEND,
        RESUME,
        TERMINATE,
        SINGLETON,
        LABEL;

    }
}

