/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.plugins.translator;

import java.util.Arrays;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import neverlang.compiler.plugins.translator.JavaTranslatorPlugin;
import neverlang.utils.StringUtils;

public class TemplateTranslatorPlugin
extends JavaTranslatorPlugin {
    final String defaultAttribute = "Text";
    final String lExprlDelim = "{{";
    final String rExprDelim = "}}";
    final String lStmtDelim = "[[";
    final String rStmtDelim = "]]";
    final Pattern stmtPattern = Pattern.compile(Pattern.quote("[[") + "(.*?)" + Pattern.quote("]]"));
    final Pattern expressionPattern = Pattern.compile(Pattern.quote("{{") + "(.*?)" + Pattern.quote("}}"));

    public TemplateTranslatorPlugin() {
        this.language = "template";
        this.defaultLanguage = false;
    }

    @Override
    public String formatSource(String inputString) {
        String quotedString = this.quote(inputString);
        Matcher matcher = this.expressionPattern.matcher(quotedString);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String replacement = super.formatSource(this.unquote(matchResult.group(1)));
            quotedString = quotedString.substring(0, matchResult.start()) + "\" + ( " + replacement + " ) + \"" + quotedString.substring(matchResult.end());
            matcher.reset(quotedString);
        }
        String[] lines = quotedString.split("\r\n|\r|\n");
        String joined = StringUtils.join(Arrays.asList(lines), "\\n\"+\n\"");
        return String.format("$ctx.node().setValue(\"%s\",\n\"%s\");", "Text", joined);
    }

    private String quote(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private String unquote(String input) {
        return input.replace("\\\"", "\"").replace("\\\\", "\\");
    }
}

