/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.mdl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import neverlang.compiler.mdl.PredicateGuard;
import neverlang.utils.Tuple;

public class TypeAnyGuard
extends PredicateGuard {
    List<Tuple<String, String>> constraints = new ArrayList<Tuple<String, String>>();

    public TypeAnyGuard(String predicate, int priority, boolean isSoft) {
        super(predicate, priority, isSoft);
        this.processGuard();
    }

    private void processGuard() {
        Pattern patt = Pattern.compile("([$A-Za-z_][\\[\\]\\.$0-9A-Za-z_]*\\s*:\\s*[^&\\|\\,\\s]+)\\s*,*");
        Matcher matcher = patt.matcher(this.getPredicate().trim());
        boolean first = true;
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            if (first) {
                first = false;
                if (matchResult.start() != 0) {
                    System.err.println(String.format(">> ERROR: Syntax error in guard: %s\n", this.toString()));
                    System.err.println("          Check that every constraint is of the form <name> : <type>\n");
                }
            }
            try {
                String[] matched = matchResult.group(1).split(":");
                this.constraints.add(new Tuple<String, String>(matched[0].trim(), matched[1].trim()));
            }
            catch (RuntimeException e) {
                System.err.println(String.format("Type guard Syntax error.\n\nGuard = %s\n\n%s", this.predicate, e.getMessage()));
            }
        }
        System.out.println("Done");
    }

    public List<Tuple<String, String>> getConstraints() {
        return this.constraints;
    }

    public void printConstraints() {
        System.out.println("Constraints for: " + this);
        for (Tuple<String, String> c : this.constraints) {
            System.out.println("- >" + (String)c.x + "< : >" + (String)c.y + "<");
        }
    }

    @Override
    public String toString() {
        String prio = this.getPriority() == LOWEST_PRIORITY ? "lowest" : String.valueOf(this.getPriority());
        return MessageFormat.format("type_any{1} [{2}] ({0})", this.getPredicate(), this.isPermanent() ? "!" : "", prio);
    }
}

