/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.mdl;

import dexter.grammar.Production;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import neverlang.compiler.mdl.Annotation;
import neverlang.compiler.mdl.ExceptionGuard;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.compiler.mdl.PredicateGuard;
import neverlang.compiler.mdl.TypeAnyGuard;
import neverlang.compiler.mdl.UndefinedLabelException;
import neverlang.compiler.plugins.translator.JavaTranslatorPlugin;
import neverlang.compiler.plugins.translator.TranslatorPlugin;
import neverlang.runtime.Syntax;

public class SemanticActionSource
extends TranslatorPlugin {
    static int actionID = 1;
    TranslatorPlugin impl = new JavaTranslatorPlugin();
    boolean isDefaultLanguage = true;
    String language = "java";
    private int offset;
    ArrayList<Annotation> annotations = new ArrayList();
    ArrayList<ExceptionGuard> exceptions = new ArrayList();

    public SemanticActionSource(String src) {
        this.impl.setActionID(actionID++);
        this.impl.setSource(src);
    }

    @Override
    public String[] getEndemicSlices() {
        return this.impl.getEndemicSlices();
    }

    public SemanticActionSource(String src, boolean evalChildren) {
        this(src);
        this.shouldEvalChildren = evalChildren;
        this.impl.setShouldEvalChildren(evalChildren);
    }

    public void setLanguageTranslator(TranslatorPlugin newPlugin) {
        TranslatorPlugin oldPlugin = this.impl;
        newPlugin.setRoleName(oldPlugin.getRoleName());
        newPlugin.setPos(this.getPos());
        newPlugin.setModule(oldPlugin.getModule());
        newPlugin.setPredicate(oldPlugin.getPredicate());
        newPlugin.setException(oldPlugin.getException());
        newPlugin.setNameSuffix(oldPlugin.getNameSuffix());
        newPlugin.setActionID(oldPlugin.getActionID());
        newPlugin.setLabel(oldPlugin.getLabel());
        newPlugin.setPriority(oldPlugin.getPriority());
        this.impl = newPlugin;
        this.impl.setSource(oldPlugin.getSource());
        this.impl.setShouldEvalChildren(this.shouldEvalChildren);
    }

    @Override
    public String getLabel() {
        return this.impl.getLabel();
    }

    @Override
    public SemanticActionSource setLabel(String l) {
        this.impl.setLabel(l);
        return this;
    }

    @Override
    public boolean isDefaultLanguage() {
        return this.isDefaultLanguage;
    }

    void setInheritedLanguage(String langSpec) {
        if (!this.isDefaultLanguage) {
            throw new UnsupportedOperationException();
        }
        this.language = langSpec;
    }

    public void setLanguage(String langSpec) {
        if (!this.isDefaultLanguage) {
            throw new UnsupportedOperationException();
        }
        this.isDefaultLanguage = false;
        this.language = langSpec;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getFileExtension() {
        return this.impl.getFileExtension();
    }

    @Override
    public void setModule(ModuleSource m) {
        this.impl.setModule(m);
        this.impl.setRuleIndex(this.ruleindex);
    }

    @Override
    public ModuleSource getModule() {
        return this.impl.getModule();
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    @Override
    public void setRoleName(String r) {
        super.setRoleName(r);
        this.impl.setRoleName(r);
    }

    @Override
    public String getRoleName() {
        return this.impl.getRoleName();
    }

    @Override
    public String getName() {
        return this.impl.getName();
    }

    @Override
    public String getPackageString() {
        return this.impl.toString();
    }

    @Override
    public void setPos(int i) {
        super.setPos(i);
        this.impl.setPos(i);
    }

    @Override
    public String getSource() {
        return this.impl.getSource();
    }

    @Override
    public void setSource(String s) {
        this.impl.setSource(s);
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    @Override
    public int getPos() {
        int _pos = this.impl.getPos();
        if (!this.hasLabel()) {
            if (_pos == -1) {
                throw new RuntimeException("Pos was not initialized");
            }
            return _pos;
        }
        ModuleSource m = this.getModule();
        Syntax syntax2 = m.getSyntaxRole();
        Production prod = syntax2.getByLabel(this.getLabel());
        if (prod == null) {
            throw new UndefinedLabelException(this.getLabel(), m);
        }
        return syntax2.getPos(prod) + this.offset;
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    @Override
    protected String replaceFieldAssignments(MatchResult mr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String replaceFieldReads(MatchResult mr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String replaceIdentifiers(MatchResult mr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String formatImports(List<String> importList) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String replaceTerminals(MatchResult mr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void isSingleAciton(boolean isSingle) {
        this.impl.isSingleAction(isSingle);
    }

    public boolean isTube() {
        return false;
    }

    public void setAnnotations(ArrayList<Annotation> annotations) {
        this.annotations = annotations;
        for (Annotation a : annotations) {
            if (a instanceof PredicateGuard) {
                PredicateGuard pa = (PredicateGuard)a;
                this.impl.setPredicate(pa);
                continue;
            }
            if (!(a instanceof ExceptionGuard)) continue;
            ExceptionGuard ex = (ExceptionGuard)a;
            this.impl.setException(ex);
        }
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ExceptionGuard getException() {
        return this.impl.getException();
    }

    @Override
    public void setException(ExceptionGuard e) {
        this.impl.setException(e);
    }

    @Override
    public void setNameSuffix(String suff) {
        this.impl.setNameSuffix(suff);
    }

    @Override
    public String getNameSuffix() {
        return this.impl.getNameSuffix();
    }

    @Override
    public int getActionID() {
        return this.impl.getActionID();
    }

    @Override
    public String getCleanName() {
        return this.impl.getCleanName();
    }

    public boolean hasTypeAnyGuard() {
        PredicateGuard guard = this.impl.getPredicate();
        return guard != null && guard instanceof TypeAnyGuard;
    }

    public TypeAnyGuard getTypeAnyGuard() {
        PredicateGuard guard = this.impl.getPredicate();
        if (guard != null && guard instanceof TypeAnyGuard) {
            return (TypeAnyGuard)guard;
        }
        return null;
    }

    @Override
    public PredicateGuard getPredicate() {
        return this.impl.getPredicate();
    }

    @Override
    public void setPredicate(PredicateGuard g) {
        this.impl.setPredicate(g);
    }

    @Override
    public void setPriority(int priority) {
        this.impl.setPriority(priority);
    }

    @Override
    public int getPriority() {
        return this.impl.getPriority();
    }
}

