/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler.mdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import neverlang.compiler.mdl.MissingNonterminalException;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.runtime.Context;
import neverlang.runtime.Production;
import neverlang.runtime.SemanticAction;

public abstract class AbstractSemanticActionSource
implements SemanticAction {
    String src;
    String mname;
    String rolename;
    String language = "java";
    boolean isDefaultLanguage = true;
    int pos;
    final String id = "\\$(\\d+)";
    final String nonterminal = "\\$(\\d+)\\.(\\w+)";
    final String terminal = "#(\\d+)";
    Pattern assignment = Pattern.compile("\\$(\\d+)\\.(\\w+)\\s*=([^;]+);");
    Pattern access = Pattern.compile("\\$(\\d+)\\.(\\w+)");
    Pattern identifier = Pattern.compile("\\$(\\d+)");
    Pattern terminalId = Pattern.compile("#(\\d+)");
    String tplName = "%s$role$%s$%d";
    String[] defaultImports;
    String bodyTpl;
    protected String cname;
    protected ModuleSource module;
    protected int ruleindex = -1;

    public AbstractSemanticActionSource() {
    }

    public AbstractSemanticActionSource(String src) {
        this.src = src;
    }

    public void setSource(String src) {
        this.src = src;
    }

    public void setDefaultImports(String[] defaultImports) {
        this.defaultImports = defaultImports;
    }

    protected void setBodyTemplate(String bodyTpl) {
        this.bodyTpl = bodyTpl;
    }

    protected String formatSource(String src) {
        src = this.replaceMatches(src, this.assignment, Phase.ASSIGN);
        src = this.replaceMatches(src, this.access, Phase.FIELD);
        src = this.replaceMatches(src, this.identifier, Phase.ID);
        src = this.replaceMatches(src, this.terminalId, Phase.TERMINAL);
        return src;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.defaultImports));
        list.addAll(this.module.getImports());
        return this.getPackageString() + this.formatImports(list) + String.format(this.bodyTpl, this.getName(), this.formatSource(this.src));
    }

    public String getName() {
        return String.format(this.tplName, this.module.getName(), this.rolename, this.pos);
    }

    public void setRoleName(String rolename) {
        this.rolename = rolename;
    }

    protected String getRoleName() {
        return this.rolename;
    }

    protected void setPos(int pos) {
        this.pos = pos;
    }

    protected int getPos() {
        return this.pos;
    }

    protected int getRuleIndex() {
        if (this.ruleindex < 0) {
            throw new RuntimeException("Invalid ruleindex " + this.ruleindex + ". Did you set a parent Module?");
        }
        return this.ruleindex;
    }

    public void setModule(ModuleSource m) {
        int lastidx = 0;
        this.module = m;
        dexter.grammar.Production[] ps = this.module.getSyntax();
        if (ps.length == 0) {
            throw new RuntimeException("ERROR: No syntax for module " + m.getCanonicalName());
        }
        int i = 0;
        int idx = 0;
        Production p = (Production)ps[i];
        while (idx < this.pos) {
            if (i == ps.length) {
                throw new MissingNonterminalException(this.pos);
            }
            lastidx = idx;
            idx = ((Production)ps[i]).getIndex();
            ++i;
        }
        this.ruleindex = idx == this.pos ? idx : lastidx;
    }

    public abstract String getPackageString();

    protected abstract String replaceFieldAssignments(MatchResult var1);

    protected abstract String replaceFieldReads(MatchResult var1);

    protected abstract String replaceIdentifiers(MatchResult var1);

    protected abstract String replaceTerminals(MatchResult var1);

    protected abstract String formatImports(List<String> var1);

    protected String replaceMatches(String string, Pattern p, Phase replaceAssignments) {
        Matcher matcher = p.matcher(string);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String replacement = null;
            try {
                switch (replaceAssignments) {
                    case ASSIGN: {
                        replacement = String.format(this.replaceFieldAssignments(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(2), matchResult.group(3));
                        break;
                    }
                    case FIELD: {
                        replacement = String.format(this.replaceFieldReads(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(2));
                        break;
                    }
                    case ID: {
                        replacement = String.format(this.replaceIdentifiers(matchResult), this.calcId(Integer.parseInt(matchResult.group(1))), matchResult.group(1));
                        break;
                    }
                    case TERMINAL: {
                        replacement = String.format(this.replaceTerminals(matchResult), Integer.parseInt(matchResult.group(1)), matchResult.group(1));
                    }
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
            string = string.substring(0, matchResult.start()) + replacement + string.substring(matchResult.end());
            matcher.reset(string);
        }
        return string;
    }

    private int calcId(int dollarNotationValue) {
        if (dollarNotationValue == this.getRuleIndex()) {
            return dollarNotationValue;
        }
        int retVal = dollarNotationValue - (this.getRuleIndex() + 1);
        if (retVal < 0) {
            throw new RuntimeException("Wrong numbering!! in action #" + this.pos + ": cannot refer $" + dollarNotationValue + ", head of rule was $" + this.getRuleIndex());
        }
        return retVal;
    }

    @Override
    public void apply(Context $ctx) {
        throw new UnsupportedOperationException();
    }

    public void setLanguage(String langSpec) {
        if (!this.isDefaultLanguage) {
            throw new UnsupportedOperationException();
        }
        this.isDefaultLanguage = false;
        this.language = langSpec;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isDefaultLanguage() {
        return this.isDefaultLanguage;
    }

    void setInheritedLanguage(String langSpec) {
        if (!this.isDefaultLanguage) {
            throw new UnsupportedOperationException();
        }
        this.language = langSpec;
    }

    public abstract String getFileExtension();

    private static enum Phase {
        ASSIGN,
        FIELD,
        ID,
        TERMINAL;

    }
}

