/*
 * Decompiled with CFR 0.152.
 */
package neverlang.compiler;

import java.util.HashMap;
import java.util.Map;
import neverlang.compiler.plugins.translator.TranslatorPlugin;

public class NeverlangSys {
    static Map<String, Class<? extends TranslatorPlugin>> actionTranslators = new HashMap<String, Class<? extends TranslatorPlugin>>();

    public static void registerTranslator(String forLanguage, String className) {
        ClassLoader cl = NeverlangSys.class.getClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            actionTranslators.put(forLanguage, clazz);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Could not load " + className + ": does not extends TranslatorPlugin");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean hasLanguage(String forLanguage) {
        return actionTranslators.containsKey(forLanguage);
    }

    public static TranslatorPlugin getTranslator(String forLanguage) {
        if (actionTranslators.containsKey(forLanguage)) {
            try {
                return actionTranslators.get(forLanguage).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException(String.format("No available translator for language '%s'", forLanguage));
    }

    static {
        NeverlangSys.registerTranslator("java", "neverlang.compiler.plugins.translator.JavaTranslatorPlugin");
        NeverlangSys.registerTranslator("scala", "neverlang.compiler.plugins.translator.ScalaTranslatorPlugin");
        NeverlangSys.registerTranslator("template", "neverlang.compiler.plugins.translator.TemplateTranslatorPlugin");
    }
}

