/*
 * Decompiled with CFR 0.152.
 */
package neverlang;

import dexter.grammar.TerminalSym;
import dexter.lexter.RegexTerminalSym;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import neverlang.GenericMain;
import neverlang.compiler.BundleWriter;
import neverlang.compiler.CategoryMapperWriter;
import neverlang.compiler.EndemicSliceWriter;
import neverlang.compiler.LangWriter;
import neverlang.compiler.ModuleWriter;
import neverlang.compiler.NeverlangLang;
import neverlang.compiler.SliceWriter;
import neverlang.compiler.UnitHolder;
import neverlang.compiler.UnitWriter;
import neverlang.compiler.lang.LangSource;
import neverlang.compiler.mdl.MissingNonterminalException;
import neverlang.compiler.mdl.ModuleSource;
import neverlang.compiler.syn.ImportedSyntax;
import neverlang.compiler.syn.MissingSyntax;
import neverlang.compiler.syn.category.Categories;
import neverlang.runtime.EndemicSlice;
import neverlang.runtime.MissingSyntaxException;
import neverlang.runtime.Module;
import neverlang.runtime.Slice;
import neverlang.runtime.Syntax;
import neverlang.runtime.Unit;
import neverlang.runtime.dexter.ASTNode;
import neverlang.runtime.dexter.ParsingException;
import neverlang.utils.StringUtils;

public class Nlgc
extends GenericMain {
    public static boolean VERBOSE = false;
    public static final int VERSION_MAJOR = 0;
    public static final int VERSION_MINOR = 8;
    public static final int VERSION_MINOR_MINOR = 0;
    public static final String VERSION_POSTFIX = "experimental";
    HashMap<String, String> files = new HashMap();
    File outDir;
    private boolean isOpen = false;
    private List<String> errors = Collections.emptyList();

    public Nlgc() {
    }

    public Nlgc(String[] args) {
        super(args);
        this.parseArgs();
    }

    @Override
    public void readFiles() throws IOException {
        super.readFiles();
        int nFiles = this.fileList.size();
        for (int i = 0; i < nFiles; ++i) {
            this.files.put((String)this.filePaths.get(i), (String)this.fileList.get(i));
        }
    }

    private String printTerminalSymbol(TerminalSym s) {
        return s instanceof RegexTerminalSym ? ((RegexTerminalSym)s).toString() : '\'' + s.toString() + '\'';
    }

    private String printTerminalSymbols(Collection<TerminalSym> ss) {
        ArrayList<String> l = new ArrayList<String>();
        for (TerminalSym s : ss) {
            l.add(this.printTerminalSymbol(s));
        }
        return StringUtils.join(l, ", ");
    }

    @Override
    public void processFiles() throws Exception {
        Object units;
        if (this.files.isEmpty()) {
            return;
        }
        NeverlangLang nlg = new NeverlangLang();
        ArrayList<Unit> processedFiles = new ArrayList<Unit>();
        ArrayList unprocessedFiles = new ArrayList(this.filePaths);
        ArrayList<String> errors = new ArrayList<String>();
        while (!unprocessedFiles.isEmpty()) {
            String f = (String)unprocessedFiles.remove(0);
            try {
                System.out.println(f);
                ASTNode t = nlg.exec(this.files.get(f));
                UnitHolder uh = (UnitHolder)t.getValue("$UnitHolder");
                units = uh.getList();
                processedFiles.addAll((Collection<Unit>)units);
            }
            catch (ParsingException e) {
                TerminalSym unexpSym = e.getUnexpectedSymbol().getSymbol();
                errors.add(String.format("%s:%d:%d: Unexpected symbol %s. Expected: %s.\n", f, e.getUnexpectedSymbol().row, e.getUnexpectedSymbol().col, this.printTerminalSymbol(unexpSym), this.printTerminalSymbols(e.getExpectedSymbols())));
            }
            catch (MissingNonterminalException e) {
                errors.add(String.format("%s: Cannot attach rule to nonterminal $%s. No such nonterminal.\n", f, e.getMessage()));
            }
            catch (MissingSyntaxException e) {
                e.printStackTrace();
                errors.add(String.format("%s: Cannot process module, missing compiled syntax %s.\n", f, e.getMessage()));
            }
        }
        Unit uu = null;
        Categories categories = new Categories();
        CategoryMapperWriter catWriter = new CategoryMapperWriter(this.outDir);
        try {
            units = processedFiles.iterator();
            while (units.hasNext()) {
                UnitWriter sw;
                Unit u;
                uu = u = (Unit)units.next();
                if (u instanceof ModuleSource) {
                    ModuleSource m = (ModuleSource)u;
                    Syntax moduleSyntax = null;
                    String syntaxFrom = m.getSyntaxFrom();
                    if (syntaxFrom != null) {
                        moduleSyntax = this.findSyntax(syntaxFrom, processedFiles);
                        if (moduleSyntax instanceof MissingSyntax) {
                            moduleSyntax = this.loadSyntaxFromClasspath(syntaxFrom);
                        }
                        m.setSyntax(moduleSyntax);
                    } else {
                        moduleSyntax = m.getSyntaxRole();
                        categories.updateCategories(m.getDeclaredCategories());
                    }
                    if (moduleSyntax instanceof MissingSyntax) {
                        errors.add("Module " + m.getCanonicalName() + " requires syntax in " + m.getSyntaxFrom() + " but it could not be found. Add the source to the command line, or put the pre-compiled component on the classpath.");
                        continue;
                    }
                    ModuleWriter mw = new ModuleWriter(m, this.outDir);
                    if (!(moduleSyntax instanceof ImportedSyntax)) {
                        mw.writeSyntax();
                    }
                    mw.writeRoles();
                    mw.writeModule();
                    continue;
                }
                if (u instanceof Slice) {
                    sw = new SliceWriter((Slice)u, this.outDir);
                    ((SliceWriter)sw).writeSlice();
                    continue;
                }
                if (u instanceof EndemicSlice) {
                    sw = new EndemicSliceWriter((EndemicSlice)u, this.outDir);
                    ((EndemicSliceWriter)sw).writeEndemicSlice();
                    continue;
                }
                if (u instanceof LangSource) {
                    LangSource ls = (LangSource)u;
                    ls.setIsOpen(this.isOpen);
                    if (ls.isBundle()) {
                        BundleWriter bw = new BundleWriter(ls, this.outDir);
                        bw.writeBundle();
                        continue;
                    }
                    LangWriter lw = new LangWriter(ls, this.outDir);
                    lw.writeLanguage();
                    catWriter.setLanguage(ls);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot write this type of source file " + u.getCanonicalName());
            }
            catWriter.writeCategoryMapper(categories);
        }
        catch (Exception ex) {
            errors.add(String.format("%s: Error occurred while processing file \n", uu.getCanonicalName()));
            ex.printStackTrace();
        }
        this.printErrors(errors);
        this.errors = errors;
        if (errors.size() > 0) {
            System.exit(-1);
        }
    }

    public void setOutputDir(String outDir) {
        this.outDir = new File(outDir);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private Syntax findSyntax(String requiredModule, List<Unit> processedFiles) {
        for (Unit u : processedFiles) {
            if (!(u instanceof Module) || !u.getCanonicalName().equals(requiredModule)) continue;
            return new ImportedSyntax(((Module)u).getSyntaxRole());
        }
        return new MissingSyntax();
    }

    private Syntax loadSyntaxFromClasspath(String syntaxFrom) {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            String classFrom = syntaxFrom + "$role$syntax";
            System.out.println("trying to load from " + classFrom);
            Class<?> clazz = cl.loadClass(syntaxFrom + "$role$syntax");
            Syntax syn = (Syntax)clazz.newInstance();
            return new ImportedSyntax(syn);
        }
        catch (Exception err) {
            System.out.println("not found.");
            return MissingSyntax.INSTANCE;
        }
    }

    private void printErrors(List<String> errorMsgs) {
        if (errorMsgs.isEmpty()) {
            return;
        }
        System.out.println();
        System.err.printf("Found %d error(s): \n", errorMsgs.size());
        for (String err : errorMsgs) {
            System.err.println(err);
        }
    }

    public void setFilePaths(List<String> files) {
        this.filePaths = files;
    }

    public void setOpen() {
        this.isOpen = true;
    }
}

