/*
 * Decompiled with CFR 0.152.
 */
package neverlang;

import dexter.grammar.TerminalSym;
import dexter.lexter.RegexTerminalSym;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import neverlang.Nlgc;
import neverlang.utils.StringUtils;

public class Main
extends Nlgc {
    public static boolean DEMO_MODE = Boolean.parseBoolean(System.getenv("NEVERLANG_DEMO_MODE"));
    private URLClassLoader classloader;

    public static void main(String[] args) throws Exception {
        try {
            Main m = new Main(args);
            m.parseArgs();
            m.readFiles();
            m.processFiles();
        }
        catch (Exception e) {
            if (DEMO_MODE) {
                System.err.println(e.getMessage());
            }
            throw e;
        }
    }

    public Main() {
    }

    public Main(String[] args) {
        super(args);
        System.out.println("----------------------------------------");
        System.out.printf("Using Neverlang RSD Compiler %d.%d.%d\n", 0, 8, 0);
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            System.out.println("Compiled on: " + new Date(jarFile.lastModified()) + "\n");
        }
        catch (URISyntaxException e1) {
            System.out.println("Compiled on: unknwon.\n");
        }
    }

    @Override
    public void parseArgs() {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder verbose = parser.acceptsAll(Arrays.asList("v", "verbose"), "Enable verbose output");
        ArgumentAcceptingOptionSpec<String> destDir = parser.accepts("s", "Specify where to place generated source files").withRequiredArg().describedAs("dest dir");
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "Show this help message");
        ArgumentAcceptingOptionSpec<File> classpath = parser.acceptsAll(Arrays.asList("cp", "classpath"), "A '" + File.pathSeparator + "' delimited list of directories, JAR archives and ZIP archives used to look for a class file").withRequiredArg().ofType(File.class).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("classpath");
        OptionSpecBuilder version = parser.accepts("version", "Print version number");
        OptionSpecBuilder isOpen = parser.acceptsAll(Arrays.asList("o", "open"), "Generates an open interprter");
        OptionSet opts = parser.parse(this.args);
        if (opts.has(isOpen)) {
            this.setOpen();
        }
        if (opts.has(version)) {
            this.version();
            return;
        }
        if (opts.has(help)) {
            this.usage(parser);
            return;
        }
        if (opts.nonOptionArguments().isEmpty()) {
            System.err.println("No input file specified.");
            return;
        }
        Nlgc.VERBOSE = opts.has(verbose);
        this.outDir = opts.has(destDir) ? new File(opts.valueOf(destDir)) : new File(".");
        if (opts.has(classpath)) {
            this.setClasspath(opts.valuesOf(classpath));
        }
        this.setFilePaths(opts.nonOptionArguments());
    }

    private void usage(OptionParser p) {
        System.out.format("\n", new Object[0]);
        System.out.format("Usage: nlgc <options> <source files>\n", new Object[0]);
        System.out.format("\n", new Object[0]);
        try {
            p.printHelpOn(System.out);
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
        System.out.format("\n", new Object[0]);
    }

    @Override
    public void processFiles() throws Exception {
        super.processFiles();
    }

    private void version() {
        System.out.printf("Neverlang Compiler %d.%d.%d-%s\n", 0, 8, 0, "experimental");
    }

    private String printTerminalSymbol(TerminalSym s) {
        return s instanceof RegexTerminalSym ? ((RegexTerminalSym)s).toString() : '\'' + s.toString() + '\'';
    }

    private String printTerminalSymbols(Collection<TerminalSym> ss) {
        ArrayList<String> l = new ArrayList<String>();
        for (TerminalSym s : ss) {
            l.add(this.printTerminalSymbol(s));
        }
        return StringUtils.join(l, ", ");
    }

    private void setClasspath(List<File> valuesOf) {
        URL[] urls = new URL[valuesOf.size()];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = valuesOf.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.classloader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(this.classloader);
    }
}

