/*
 * Decompiled with CFR 0.152.
 */
package dexter.utils;

import dexter.parser.ParserState;
import dexter.utils.StateSet;
import java.util.HashMap;

public class GarbageCollectedMap<T>
extends HashMap<T, StateSet> {
    @Override
    public StateSet get(Object s) {
        StateSet set = (StateSet)super.get(s);
        if (set == null) {
            set = new StateSet();
            this.put(s, set);
            return set;
        }
        return this.gc(set);
    }

    public StateSet gc(StateSet set) {
        StateSet invalid = new StateSet();
        for (ParserState s : set) {
            if (!s.isInvalid()) continue;
            invalid.add(s);
        }
        if (!invalid.isEmpty()) {
            System.out.println("Garbage collected: " + invalid + " in " + set);
        }
        set.removeAll(invalid);
        return set;
    }
}

