/*
 * Decompiled with CFR 0.152.
 */
package dexter.parser;

import dexter.grammar.Grammar;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.TerminalSym;
import dexter.parser.Graph;
import dexter.parser.Item;
import dexter.parser.LookaheadItemSet;
import dexter.parser.LookaheadSet;
import dexter.parser.ParserState;
import dexter.utils.NoSuchTransitionException;
import java.util.ArrayList;
import java.util.Set;

public class LookaheadUpdater
implements Graph.Visitor {
    Grammar g;
    boolean dirty = false;

    public LookaheadUpdater(Grammar g) {
        this.g = g;
    }

    private boolean copyToTransition(ParserState s, Item nextItem, Set<TerminalSym> newLookaheads) {
        try {
            ParserState nextstate = s.goTo.getTransition(nextItem.getSymbolAtPos());
            int lookaheadsize = nextstate.kernel.sizeOfLookaheads();
            nextstate.kernel.getLookahead(nextItem.next()).addAll(newLookaheads);
            if (lookaheadsize != nextstate.kernel.sizeOfLookaheads()) {
                nextstate.setDirty();
                return true;
            }
        }
        catch (NoSuchTransitionException noSuchTransitionException) {
            // empty catch block
        }
        return false;
    }

    public boolean performUpdate(ParserState s) {
        boolean dirt = false;
        LookaheadItemSet lookaheadCache = new LookaheadItemSet();
        lookaheadCache.addAll(s.kernel);
        for (Item kernelItem : s.kernel) {
            if (kernelItem.isCandidate()) continue;
            ArrayList<Item> nextItems = new ArrayList<Item>();
            nextItems.add(kernelItem);
            for (int i = 0; i < nextItems.size(); ++i) {
                Item nextItem = (Item)nextItems.get(i);
                if (!nextItem.isCandidate()) {
                    dirt |= this.copyToTransition(s, nextItem, lookaheadCache.getLookahead(nextItem));
                }
                if (nextItem.getSymbolAtPos() instanceof TerminalSym) continue;
                NonTerminalSym X = (NonTerminalSym)nextItem.getSymbolAtPos();
                for (Production impliedProd : this.g.getProductions(X)) {
                    Item impliedItem = impliedProd.toItem();
                    if (!nextItems.contains(impliedItem)) {
                        nextItems.add(impliedItem);
                    }
                    LookaheadSet newLa = new LookaheadSet();
                    newLa.addAll(this.g.firstTable.first(nextItem.rest()));
                    if (newLa.isEmpty() || newLa.contains(Grammar.EPSILON)) {
                        newLa.addAll(lookaheadCache.getLookahead(nextItem));
                    }
                    lookaheadCache.getLookahead(impliedItem).addAll(newLa);
                    dirt |= !newLa.isEmpty();
                }
            }
        }
        return dirt;
    }

    @Override
    public void visit(ParserState s) {
        if (s.isDirty()) {
            s.toggleDirty();
            this.dirty |= this.performUpdate(s);
        }
    }
}

