/*
 * Decompiled with CFR 0.152.
 */
package dexter.grammar;

import dexter.HashSet;
import dexter.grammar.NonTerminalSym;
import dexter.grammar.Production;
import dexter.grammar.ProductionBody;
import dexter.grammar.Symbol;
import dexter.grammar.TerminalSym;
import dexter.parser.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductionSet
extends HashMap<NonTerminalSym, Set<Production>>
implements Serializable {
    private static final long serialVersionUID = -1831416536193153051L;
    Map<String, TerminalSym> terminals = new HashMap<String, TerminalSym>();
    Map<String, NonTerminalSym> nonterminals = new HashMap<String, NonTerminalSym>();

    public ProductionSet(Production ... pset) {
        for (Production p : pset) {
            this.put(p);
        }
    }

    @Override
    public void put(NonTerminalSym nt, Symbol ... body) {
        this.put(new Production(nt, body));
    }

    @Override
    public void put(NonTerminalSym nt, ProductionBody body) {
        this.put(new Production(nt, body));
    }

    public void put(Production p) {
        HashSet<Production> b = (HashSet<Production>)super.get(p.nt);
        if (null == b) {
            b = new HashSet<Production>();
            this.put(p.nt, b);
        }
        b.add(p);
    }

    @Override
    public Set<Production> get(Object o) {
        if (super.get(o) == null) {
            return Collections.emptySet();
        }
        return (Set)super.get(o);
    }

    public List<Production> getProductions() {
        ArrayList<Production> list = new ArrayList<Production>();
        for (NonTerminalSym A : this.keySet()) {
            list.addAll(this.getProductions(A));
        }
        return list;
    }

    public List<Production> getProductions(NonTerminalSym A) {
        return new ArrayList<Production>((Collection<Production>)this.get(A));
    }

    public List<Item> getItemSet() {
        ArrayList<Item> list = new ArrayList<Item>();
        for (Production p : this.getProductions()) {
            list.add(p.toItem());
        }
        return list;
    }

    public void check() throws Exception {
        HashSet<NonTerminalSym> nt = new HashSet<NonTerminalSym>();
        HashSet<NonTerminalSym> verifnt = new HashSet<NonTerminalSym>();
        HashSet t = new HashSet();
        for (Item i : this.getItemSet()) {
            nt.add(i.nt);
            for (Symbol s : i.body) {
                if (!(s instanceof NonTerminalSym)) continue;
                verifnt.add((NonTerminalSym)s);
            }
        }
        for (NonTerminalSym s : nt) {
            verifnt.remove(s);
        }
        if (verifnt.size() > 0) {
            throw new Exception("Exceeding NonTerminals " + ((Object)verifnt).toString() + " Grammar is in PENDING STATE");
        }
        for (TerminalSym terminal : t) {
            this.terminals.put(terminal.toString(), terminal);
        }
        for (NonTerminalSym nonterminal : nt) {
            this.nonterminals.put(nonterminal.toString(), nonterminal);
        }
    }

    public NonTerminalSym nt(String nts) {
        return this.nonterminals.get(nts);
    }

    public TerminalSym t(String ts) {
        return this.terminals.get(ts);
    }
}

