/*
 * Decompiled with CFR 0.152.
 */
package dexter.grammar;

import dexter.grammar.Grammar;
import dexter.grammar.IProductionBody;
import dexter.grammar.Production;
import dexter.grammar.Symbol;
import dexter.grammar.SymbolSet;
import dexter.grammar.SymbolSetTable;
import dexter.grammar.TerminalSym;
import dexter.utils.VisitableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FirstTable
extends SymbolSetTable<Symbol, TerminalSym> {
    Grammar g;

    public FirstTable(Grammar g) {
        this.g = g;
    }

    public void update() {
        SymbolSet<Symbol> symbolSet = new SymbolSet<Symbol>();
        for (Production p : this.g.getProductions()) {
            symbolSet.add(p.nt);
            symbolSet.addAll(p.body);
        }
        this.put(Grammar.EOF, Grammar.EOF);
        this.put(this.g.getAxiom(), Grammar.EOF);
        int total = 0;
        int i = 0;
        do {
            ++i;
            int last = total;
            for (Symbol X : symbolSet) {
                total += this.calcFirst(X);
            }
        } while (total > 0);
    }

    public int calcFirst(Symbol X) {
        System.out.println("first: " + X);
        if (X instanceof TerminalSym) {
            return this.put(X, (TerminalSym)X);
        }
        Object prods = this.g.get(X);
        System.out.println("prods: " + prods);
        if (prods == null) {
            System.err.println("There are pending productions for symbol " + X);
            return 0;
        }
        Object thisFirst = this.get(X);
        if (this.g.nullables.isNullable(X)) {
            ((VisitableSet)thisFirst).add(Grammar.EPSILON);
        }
        int before = 0;
        Iterator iterator = prods.iterator();
        while (iterator.hasNext()) {
            Production X_omega = (Production)iterator.next();
            IProductionBody omega = X_omega.body;
            before += ((HashSet)thisFirst).size();
            int eps = 0;
            for (Symbol Y : omega) {
                Object fst = this.get(Y);
                if (((HashSet)fst).contains(Grammar.EPSILON)) continue;
                ((VisitableSet)thisFirst).addAll(fst);
            }
            if (eps != prods.size()) continue;
            ((VisitableSet)thisFirst).add(Grammar.EPSILON);
        }
        System.out.println("thisFirst " + thisFirst);
        return ((HashSet)thisFirst).size() - before;
    }

    public Set<TerminalSym> first(List<Symbol> XS) {
        boolean nulls = false;
        boolean startNull = false;
        HashSet<TerminalSym> firstSet = new HashSet<TerminalSym>();
        System.out.println("FIRST:" + XS);
        int eps = 0;
        for (int i = 0; i < XS.size() && eps == i; ++i) {
            Symbol Y_i = XS.get(i);
            Iterator iterator = ((HashSet)this.get(Y_i)).iterator();
            while (iterator.hasNext()) {
                TerminalSym a = (TerminalSym)iterator.next();
                if (a.equals(Grammar.EPSILON)) {
                    ++eps;
                    continue;
                }
                firstSet.add(a);
            }
        }
        if (eps == XS.size()) {
            firstSet.add(Grammar.EPSILON);
        }
        System.out.println(firstSet);
        return firstSet;
    }
}

