/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.CountLabel;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class ProgressPanel
extends JPanel {
    private transient Appender _progressAppender;
    CountLabel _errors;
    private CountLabel _files;
    CountLabel _warnings;
    private JButton _stopButton;
    private JLabel _text;
    private JProgressBar _progressBar;
    boolean _isStopped;

    public ProgressPanel() {
        this.initialize();
    }

    public void setCancelButtonVisible(boolean visible) {
        this._stopButton.setVisible(visible);
    }

    public boolean isCanceled() {
        return this._isStopped;
    }

    public void setMaximum(int value) {
        this._progressBar.setMaximum(value);
    }

    public int getMaximum() {
        return this._progressBar.getMaximum();
    }

    public int getMinimum() {
        return this._progressBar.getMinimum();
    }

    public void setProgressBarVisible(boolean visible) {
        this._progressBar.setVisible(visible);
    }

    public void setText(String text) {
        this._text.setText(text);
    }

    public void setValue(int value) {
        if (this._progressBar != null) {
            this._progressBar.setValue(value);
        }
    }

    public void dispose() {
        Loggers.ALL.removeAppender(String.valueOf(this.hashCode()));
        this._progressAppender = null;
        this._progressBar = null;
        this._stopButton = null;
        this._errors = null;
        this._warnings = null;
        this._files = null;
        this._text = null;
    }

    public void increaseErrors() {
        this._errors.increase();
    }

    public void increaseFiles() {
        this._files.increase();
    }

    public void increaseWarnings() {
        this._warnings.increase();
    }

    public void reset() {
        this._errors.reset();
        this._warnings.reset();
        this._files.reset();
        this._progressBar.setValue(0);
        this._progressBar.setMaximum(0);
        this._isStopped = false;
    }

    private void initialize() {
        ResourceBundle bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        this._errors = new CountLabel(bundle.getString("LBL_ERRORS"));
        c.insets.top = 10;
        c.insets.left = 10;
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(this._errors, c);
        this.add(this._errors);
        this._warnings = new CountLabel(bundle.getString("LBL_WARNINGS"));
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(this._warnings, c);
        this.add(this._warnings);
        this._files = new CountLabel(bundle.getString("LBL_FILES"));
        SwingHelper.setConstraints(c, 2, 0, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(this._files, c);
        this.add(this._files);
        this._stopButton = SwingHelper.createButton(bundle.getString("BTN_STOP"));
        this._stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this._isStopped = true;
            }
        });
        c.insets.right = 10;
        SwingHelper.setConstraints(c, 3, 0, 4, 1, 0.0, 0.0, 12, 2, c.insets, 0, 0);
        layout.setConstraints(this._stopButton, c);
        this.add(this._stopButton);
        this._text = new JLabel();
        c.insets.top = 15;
        SwingHelper.setConstraints(c, 0, 1, 7, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        layout.setConstraints(this._text, c);
        this.add(this._text);
        JPanel glue = new JPanel();
        c.insets.top = 20;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 2, 7, 1, 1.0, 1.0, 17, 1, c.insets, 0, 0);
        layout.setConstraints(glue, c);
        this.add(glue);
        this._progressBar = new JProgressBar();
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 3, 7, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        layout.setConstraints(this._progressBar, c);
        this.add(this._progressBar);
        Dimension size = new Dimension(400, 115);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this._progressAppender = new ProgressAppender();
        Loggers.ALL.addAppender(this._progressAppender);
    }

    private final class ProgressAppender
    extends AppenderSkeleton {
        public ProgressAppender() {
            this.name = String.valueOf(ProgressPanel.this.hashCode());
        }

        public void append(LoggingEvent ev) {
            switch (ev.getLevel().toInt()) {
                case 30000: {
                    ProgressPanel.this._warnings.increase();
                    break;
                }
                case 40000: 
                case 50000: {
                    ProgressPanel.this._errors.increase();
                }
            }
        }

        public void close() {
            Loggers.ALL.removeAppender(this);
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

