/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.ComboBoxPanel;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MessagesSettingsPage
extends AbstractSettingsPage {
    private JCheckBox _showStackTraceCheckBox;
    private JComboBox _generalComboBox;
    private JComboBox _javadocOutputComboBox;
    private JComboBox _javadocParserComboBox;
    private JComboBox _outputComboBox;
    private JComboBox _parserComboBox;
    private JComboBox _transComboBox;

    public MessagesSettingsPage() {
        this.initialize();
    }

    MessagesSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        this.updateLogger(Loggers.PARSER, (String)this._parserComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_PARSER, Level.toLevel((String)this._parserComboBox.getSelectedItem()).toInt());
        this.updateLogger(Loggers.PARSER_JAVADOC, (String)this._javadocParserComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_PARSER_JAVADOC, Level.toLevel((String)this._javadocParserComboBox.getSelectedItem()).toInt());
        this.updateLogger(Loggers.PRINTER, (String)this._outputComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_PRINTER, Level.toLevel((String)this._outputComboBox.getSelectedItem()).toInt());
        this.updateLogger(Loggers.PRINTER_JAVADOC, (String)this._javadocOutputComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_PRINTER_JAVADOC, Level.toLevel((String)this._javadocOutputComboBox.getSelectedItem()).toInt());
        this.updateLogger(Loggers.TRANSFORM, (String)this._transComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_TRANSFORM, Level.toLevel((String)this._transComboBox.getSelectedItem()).toInt());
        this.updateLogger(Loggers.IO, (String)this._generalComboBox.getSelectedItem());
        this.settings.putInt(ConventionKeys.MSG_PRIORITY_IO, Level.toLevel((String)this._generalComboBox.getSelectedItem()).toInt());
        this.settings.putBoolean(ConventionKeys.MSG_SHOW_ERROR_STACKTRACE, this._showStackTraceCheckBox.isSelected());
    }

    private void initialize() {
        Object[] prios = new String[]{Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString()};
        ComboBoxPanel parserMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_PARSER"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_PARSER, ConventionDefaults.MSG_PRIORITY_PARSER)).toString());
        this._parserComboBox = parserMessages.getComboBox();
        ComboBoxPanel javadocParserMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_PARSER_JAVADOC"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_PARSER_JAVADOC, ConventionDefaults.MSG_PRIORITY_PARSER_JAVADOC)).toString());
        this._javadocParserComboBox = javadocParserMessages.getComboBox();
        ComboBoxPanel transMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_TRANSFORM"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_TRANSFORM, ConventionDefaults.MSG_PRIORITY_TRANSFORM)).toString());
        this._transComboBox = transMessages.getComboBox();
        ComboBoxPanel outputMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_PRINTER"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_PRINTER, ConventionDefaults.MSG_PRIORITY_PRINTER)).toString());
        this._outputComboBox = outputMessages.getComboBox();
        ComboBoxPanel javadocOutputMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_PRINTER_JAVADOC"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_PRINTER_JAVADOC, ConventionDefaults.MSG_PRIORITY_PRINTER_JAVADOC)).toString());
        this._javadocOutputComboBox = javadocOutputMessages.getComboBox();
        ComboBoxPanel generalMessages = new ComboBoxPanel(this.bundle.getString("LBL_CAT_GENERAL"), prios, Level.toLevel(this.settings.getInt(ConventionKeys.MSG_PRIORITY_IO, ConventionDefaults.MSG_PRIORITY_IO)).toString());
        this._generalComboBox = generalMessages.getComboBox();
        JPanel categories = new JPanel();
        categories.setLayout(new BoxLayout(categories, 1));
        categories.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_CATEGORIES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        categories.add(generalMessages);
        categories.add(parserMessages);
        categories.add(javadocParserMessages);
        categories.add(transMessages);
        categories.add(outputMessages);
        categories.add(javadocOutputMessages);
        this._showStackTraceCheckBox = new JCheckBox(this.bundle.getString("CHK_SHOW_STACKTRACE"), this.settings.getBoolean(ConventionKeys.MSG_SHOW_ERROR_STACKTRACE, true));
        JPanel misc = new JPanel();
        misc.setLayout(new FlowLayout(0, 0, 0));
        misc.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_MISC")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        misc.add(this._showStackTraceCheckBox);
        misc.setAlignmentY(0.0f);
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        gridBag.setConstraints(categories, c);
        this.add(categories);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        gridBag.setConstraints(misc, c);
        this.add(misc);
    }

    private void updateLogger(Logger logger, String level) {
        logger.setLevel(Level.toLevel(level));
    }
}

