/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.plugin;

import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.language.Position;
import de.hunsicker.jalopy.plugin.Editor;
import de.hunsicker.jalopy.plugin.Project;
import de.hunsicker.jalopy.plugin.ProjectFile;
import de.hunsicker.jalopy.plugin.StatusBar;
import de.hunsicker.jalopy.plugin.SwingAppender;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.ProgressMonitor;
import de.hunsicker.jalopy.swing.ProgressPanel;
import de.hunsicker.swing.ErrorDialog;
import de.hunsicker.swing.util.SwingWorker;
import de.hunsicker.util.ChainingRuntimeException;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;

public abstract class AbstractPlugin {
    private static final String EMPTY_STRING = "".intern();
    private static final StatusBar DEFAULT_STATUS_BAR = new DummyStatusBar();
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.plugin.Bundle";
    protected Jalopy jalopy;
    protected SwingAppender appender;
    int offset = 0;
    Action _lastAction;
    ActionWorker _worker;
    Component _oldGlassPane;
    GlassPane _glassPane;
    final Object _lock = new Object();
    private ProgressMonitor _progressMonitor;
    final Object[] _args = new Object[3];
    int _threadCount;
    long _start;

    public AbstractPlugin() {
        this(new DefaultAppender());
    }

    public AbstractPlugin(SwingAppender appender) {
        this.appender = appender;
        this.initLogging();
    }

    public abstract Project getActiveProject();

    public abstract Frame getMainWindow();

    public long getElapsed() {
        return System.currentTimeMillis() - this._start;
    }

    public final Action getLastAction() {
        return this._lastAction;
    }

    public final synchronized Jalopy.State getState() {
        if (this.jalopy == null) {
            return Jalopy.State.UNDEFINED;
        }
        return this.jalopy.getState();
    }

    public synchronized boolean isRunning() {
        return this._worker != null;
    }

    public StatusBar getStatusBar() {
        return DEFAULT_STATUS_BAR;
    }

    public void afterEnd() {
    }

    public void beforeStart() {
    }

    public final synchronized void interrupt() {
        if (this._worker != null) {
            this._worker.interrupt();
        }
    }

    public final synchronized void performAction(Action action) {
        this.appender.clear();
        this._worker = new ActionWorker(action);
        this._worker.start();
        this._lastAction = action;
    }

    protected abstract FileFormat getFileFormat();

    public final Jalopy getEngine() {
        if (this.jalopy == null) {
            if (this._progressMonitor != null) {
                this._progressMonitor.setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_INITIALIZATION"));
            }
            this.getStatusBar().setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_INITIALIZATION"));
            this.jalopy = new Jalopy();
        }
        this.configureJalopy(this.jalopy);
        return this.jalopy;
    }

    protected ProgressMonitor createProgressMonitor() {
        return new ProgressMonitorImpl();
    }

    protected void displayError(Throwable error, Frame parent) {
        ErrorDialog d = ErrorDialog.create(this.getMainWindow(), error);
        d.setVisible(true);
        d.dispose();
    }

    protected void executeAsynchron(Runnable operation) {
        EventQueue.invokeLater(operation);
    }

    protected void executeSynchron(Runnable operation) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(operation);
    }

    protected void hideWaitCursor() {
        if (this._glassPane != null && this._glassPane.isVisible()) {
            this._glassPane.setVisible(false);
            Frame window = this.getMainWindow();
            if (window != null && window instanceof JFrame) {
                JFrame w = (JFrame)window;
                w.getRootPane().setGlassPane(this._oldGlassPane);
            }
        }
    }

    protected void showWaitCursor() {
        block3: {
            final Frame window = this.getMainWindow();
            if (window == null || !(window instanceof JFrame)) break block3;
            if (this._glassPane == null) {
                this._glassPane = new GlassPane();
            }
            this._glassPane.setThread(Thread.currentThread());
            try {
                this.executeSynchron(new Runnable(){

                    public void run() {
                        JFrame w = (JFrame)window;
                        AbstractPlugin.this._oldGlassPane = w.getRootPane().getGlassPane();
                        w.getRootPane().setGlassPane(AbstractPlugin.this._glassPane);
                        AbstractPlugin.this._glassPane.setCursor(WAIT_CURSOR);
                        AbstractPlugin.this._glassPane.setVisible(true);
                    }
                });
            }
            catch (Throwable ignored) {
                this.hideWaitCursor();
            }
        }
    }

    private void configureJalopy(Jalopy newJalopy) {
        Convention settings = Convention.getInstance();
        int backupLevel = settings.getInt(ConventionKeys.BACKUP_LEVEL, 0);
        newJalopy.setBackup(backupLevel > 0);
        newJalopy.setBackupDirectory(settings.get(ConventionKeys.BACKUP_DIRECTORY, Convention.getBackupDirectory().getAbsolutePath()));
        newJalopy.setHistoryPolicy(History.Policy.valueOf(settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY)));
        newJalopy.setHistoryMethod(History.Method.valueOf(settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD)));
        newJalopy.setInspect(settings.getBoolean(ConventionKeys.INSPECTOR, false));
        newJalopy.setBackupLevel(backupLevel);
        newJalopy.setFileFormat(this.getFileFormat());
        newJalopy.setForce(settings.getBoolean(ConventionKeys.FORCE_FORMATTING, false));
    }

    void format(ProjectFile file, final Jalopy newJalopy) throws IOException, InvocationTargetException {
        newJalopy.setEncoding(file.getEncoding());
        if (this._progressMonitor != null) {
            this._args[0] = file.getName();
            this._progressMonitor.setText(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_FORMATTING_FILE"), this._args));
            if (this._progressMonitor instanceof ProgressMonitorImpl) {
                ((ProgressMonitorImpl)this._progressMonitor).progressPanel.increaseFiles();
            }
        }
        if (!file.isReadOnly()) {
            this.getStatusBar().setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_FORMATTING"));
            if (file.isOpened()) {
                final Editor editor = file.getEditor();
                String content = editor.getText();
                if (content != null && content.length() > 0) {
                    newJalopy.setInput(content, file.getFile().getAbsolutePath());
                    List annotations = editor.detachAnnotations();
                    newJalopy.getRecognizer().attachAnnotations(annotations);
                    try {
                        this.executeSynchron(new Runnable(){

                            public void run() {
                                newJalopy.getRecognizer().setPosition(editor.getLine(), editor.getColumn());
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    final StringBuffer textBuf = new StringBuffer(content.length());
                    newJalopy.setOutput(textBuf);
                    newJalopy.format();
                    if (this._progressMonitor != null && this._progressMonitor.isCanceled()) {
                        newJalopy.getRecognizer().detachAnnotations();
                        return;
                    }
                    if (this.getState() != Jalopy.State.ERROR && !content.equals(textBuf.toString())) {
                        try {
                            this.executeSynchron(new Runnable(){

                                public void run() {
                                    editor.setText(textBuf.toString());
                                    editor.attachAnnotations(newJalopy.getRecognizer().detachAnnotations());
                                    Position position = newJalopy.getRecognizer().getPosition();
                                    editor.setCaretPosition(position.getLine(), position.getColumn());
                                }
                            });
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            } else {
                File f = file.getFile();
                newJalopy.setInput(f);
                newJalopy.setOutput(f);
                newJalopy.format();
            }
        } else {
            Object[] args = new Object[]{file};
            Loggers.IO.l7dlog(Level.INFO, "FILE_READ_ONLY", args, null);
        }
    }

    void formatSeveral(Jalopy newJalopy, Collection files) throws IOException, InvocationTargetException {
        this.formatSeveral(newJalopy, files, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatSeveral(Jalopy newJalopy, Collection files, boolean checkThreading) throws IOException, InvocationTargetException {
        block20: {
            int size = files.size();
            if (size <= 0) break block20;
            AbstractPlugin abstractPlugin = this;
            synchronized (abstractPlugin) {
                if (this._progressMonitor == null) {
                    this._progressMonitor = this.createProgressMonitor();
                    this._progressMonitor.begin(newJalopy == null ? ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MSG_INITIALIZATION") : EMPTY_STRING, files.size());
                }
            }
            int numThreads = Convention.getInstance().getInt(ConventionKeys.THREAD_COUNT, 1);
            if (!checkThreading || numThreads == 1 || size == 1) {
                Iterator i = files.iterator();
                while (i.hasNext()) {
                    if (this._progressMonitor.isCanceled()) {
                        return;
                    }
                    ProjectFile file = (ProjectFile)i.next();
                    this.format(file, newJalopy);
                    ProgressMonitor progressMonitor = this._progressMonitor;
                    synchronized (progressMonitor) {
                        this._progressMonitor.setProgress(this._progressMonitor.getProgress() + 1);
                    }
                }
            } else {
                Object part;
                List workList = files instanceof List ? (List)files : new ArrayList(files);
                int amount = 1;
                if (numThreads < size) {
                    amount = size / numThreads;
                } else {
                    numThreads = size;
                }
                this._threadCount = numThreads - 1;
                int i = 0;
                int threshold = numThreads - 1;
                while (i < threshold) {
                    Jalopy j = new Jalopy();
                    this.configureJalopy(j);
                    part = workList.subList(i * amount, (i + 1) * amount);
                    new FormatThread(j, (Collection)part).start();
                    ++i;
                }
                List rest = workList.subList((numThreads - 1) * amount, size);
                this.formatSeveral(newJalopy, rest, false);
                try {
                    part = this._lock;
                    synchronized (part) {
                        while (this._threadCount > 0) {
                            this._lock.wait();
                        }
                    }
                }
                catch (InterruptedException ignored) {}
            }
        }
    }

    synchronized void hideProgressMonitor() {
        if (this._progressMonitor != null) {
            this._progressMonitor.done();
            this._progressMonitor = null;
        }
    }

    private void initLogging() {
        if (this.appender == null) {
            this.appender = new DefaultAppender();
        }
        Loggers.initialize(this.appender);
    }

    private final class ProgressMonitorImpl
    implements ProgressMonitor {
        JDialog dialog;
        ProgressPanel progressPanel = new ProgressPanel();
        boolean running;
        int progress;

        public ProgressMonitorImpl() {
            this.progressPanel.setProgressBarVisible(true);
        }

        public synchronized void setCanceled(boolean state) {
        }

        public synchronized boolean isCanceled() {
            return this.progressPanel.isCanceled();
        }

        public synchronized void setProgress(int units) {
            if (this.running) {
                this.progress = units;
                this.progressPanel.setValue(units);
            }
        }

        public synchronized int getProgress() {
            return this.progress;
        }

        public synchronized void setText(String text) {
            if (this.running) {
                this.progressPanel.setText(text);
            }
        }

        public synchronized void begin(String text, int units) {
            if (!this.running) {
                this.dialog = new JDialog(AbstractPlugin.this.getMainWindow(), ResourceBundleFactory.getBundle(AbstractPlugin.BUNDLE_NAME).getString("TLE_FORMAT_PROGRESS"), true);
                this.dialog.setDefaultCloseOperation(2);
                this.dialog.getContentPane().add((Component)this.progressPanel, "Center");
                this.dialog.pack();
                this.dialog.setLocationRelativeTo(AbstractPlugin.this.getMainWindow());
                this.progressPanel.setText(text);
                this.progressPanel.setMaximum(units);
                AbstractPlugin.this.executeAsynchron(new Runnable(this){
                    private final /* synthetic */ ProgressMonitorImpl this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.running = true;
                        this.this$1.dialog.setVisible(true);
                    }
                });
            }
        }

        public synchronized void done() {
            if (this.running) {
                try {
                    AbstractPlugin.this.executeSynchron(new Runnable(this){
                        private final /* synthetic */ ProgressMonitorImpl this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            this.this$1.progressPanel.setValue(this.this$1.progressPanel.getMaximum());
                        }
                    });
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.dialog.setVisible(false);
                this.running = false;
                this.progressPanel.dispose();
                this.dialog.dispose();
                this.progressPanel = null;
            }
        }
    }

    private class GlassPane
    extends JComponent
    implements AWTEventListener {
        Thread thread;

        private GlassPane() {
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 3128L);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev instanceof KeyEvent) {
                KeyEvent e = (KeyEvent)ev;
                switch (e.getKeyCode()) {
                    case 27: {
                        AbstractPlugin.this.interrupt();
                        break;
                    }
                    case 67: {
                        if (!e.isControlDown()) break;
                        AbstractPlugin.this.interrupt();
                        break;
                    }
                    default: {
                        e.consume();
                    }
                }
            }
        }
    }

    private class FormatThread
    extends Thread {
        Collection files;
        Jalopy jalopy;

        public FormatThread(Jalopy jalopy, Collection files) {
            this.files = files;
            this.jalopy = jalopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AbstractPlugin.this.formatSeveral(this.jalopy, this.files, false);
            }
            catch (Exception ex) {
                throw new ChainingRuntimeException(ex);
            }
            finally {
                Object object = AbstractPlugin.this._lock;
                synchronized (object) {
                    --AbstractPlugin.this._threadCount;
                    AbstractPlugin.this._lock.notify();
                }
            }
        }
    }

    private class ActionWorker
    extends SwingWorker {
        Action action;
        int offset;

        public ActionWorker(Action action) {
            this.action = action;
        }

        public Object construct() {
            AbstractPlugin.this._start = System.currentTimeMillis();
            try {
                if (this.action == Action.FORMAT_ACTIVE) {
                    AbstractPlugin.this.showWaitCursor();
                    AbstractPlugin.this.beforeStart();
                    ProjectFile activeFile = AbstractPlugin.this.getActiveProject().getActiveFile();
                    Jalopy newJalopy = AbstractPlugin.this.getEngine();
                    AbstractPlugin.this.format(activeFile, newJalopy);
                    newJalopy.cleanupBackupDirectory();
                } else if (this.action == Action.FORMAT_ALL) {
                    AbstractPlugin.this.beforeStart();
                    Jalopy newJalopy = AbstractPlugin.this.getEngine();
                    AbstractPlugin.this.formatSeveral(newJalopy, AbstractPlugin.this.getActiveProject().getAllFiles());
                    newJalopy.cleanupBackupDirectory();
                } else if (this.action == Action.FORMAT_SELECTED) {
                    AbstractPlugin.this.beforeStart();
                    Jalopy newJalopy = AbstractPlugin.this.getEngine();
                    AbstractPlugin.this.formatSeveral(newJalopy, AbstractPlugin.this.getActiveProject().getSelectedFiles());
                    newJalopy.cleanupBackupDirectory();
                } else if (this.action == Action.FORMAT_OPEN) {
                    AbstractPlugin.this.beforeStart();
                    Jalopy newJalopy = AbstractPlugin.this.getEngine();
                    AbstractPlugin.this.formatSeveral(newJalopy, AbstractPlugin.this.getActiveProject().getOpenedFiles());
                    newJalopy.cleanupBackupDirectory();
                }
            }
            catch (Throwable ex) {
                AbstractPlugin.this.hideProgressMonitor();
                AbstractPlugin.this.displayError(ex, AbstractPlugin.this.getMainWindow());
                this.notifyAll();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (AbstractPlugin.this._lastAction == Action.FORMAT_ACTIVE) {
                    AbstractPlugin.this.hideWaitCursor();
                } else {
                    AbstractPlugin.this.hideProgressMonitor();
                }
                StatusBar statusBar = AbstractPlugin.this.getStatusBar();
                if (statusBar != null) {
                    AbstractPlugin.this._args[0] = ResourceBundleFactory.getBundle(AbstractPlugin.BUNDLE_NAME).getString(AbstractPlugin.this.getState() == Jalopy.State.ERROR ? "MSG_FORMAT_FAILED" : "MSG_FORMAT_SUCCEEDED");
                    long time = AbstractPlugin.this.getElapsed();
                    AbstractPlugin.this._args[2] = time > 999L ? ResourceBundleFactory.getBundle(AbstractPlugin.BUNDLE_NAME).getString((time /= 1000L) == 1L ? "MSG_SECOND" : "MSG_SECONDS") : ResourceBundleFactory.getBundle(AbstractPlugin.BUNDLE_NAME).getString("MSG_MILLI_SECONDS");
                    AbstractPlugin.this._args[1] = String.valueOf(time);
                    statusBar.setText(MessageFormat.format(ResourceBundleFactory.getBundle(AbstractPlugin.BUNDLE_NAME).getString("MSG_FORMAT_FINISHED"), AbstractPlugin.this._args));
                }
                AbstractPlugin.this.appender.done();
                AbstractPlugin.this.afterEnd();
                Object var5_3 = null;
                AbstractPlugin.this._worker = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                AbstractPlugin.this._worker = null;
                throw throwable;
            }
        }
    }

    private static final class DummyStatusBar
    implements StatusBar {
        private DummyStatusBar() {
        }

        public void setText(String text) {
        }
    }

    private static class DefaultAppender
    extends ConsoleAppender
    implements SwingAppender {
        public DefaultAppender() {
            super((Layout)new PatternLayout("[%p] %m\n"), "System.out");
        }

        public void clear() {
        }

        public void done() {
        }
    }

    public static final class Action {
        public static final Action UNDEFINED = new Action("undefined");
        public static final Action FORMAT_ACTIVE = new Action("format_active");
        public static final Action FORMAT_ALL = new Action("format_all");
        public static final Action FORMAT_OPEN = new Action("format_open");
        public static final Action FORMAT_SELECTED = new Action("format_selected");
        public static final Action PARSE_ACTIVE = new Action("parse_active");
        public static final Action PARSE_ALL = new Action("parse_all");
        public static final Action PARSE_OPEN = new Action("parse_open");
        public static final Action PARSE_SELECTED = new Action("parse_selected");
        public static final Action INSPECT_ACTIVE = new Action("inspect_active");
        public static final Action INSPECT_ALL = new Action("inspect_all");
        public static final Action INSPECT_OPEN = new Action("inspect_open");
        public static final Action INSPECT_SELECTED = new Action("inspect_selected");
        final String name;

        private Action(String name) {
            this.name = name.intern();
        }
    }
}

