/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language.antlr;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavadocLexer;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.antlr.InternalJavadocParser;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavaNodeFactory;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.util.Lcs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JavadocParser
extends InternalJavadocParser
implements Parser {
    private final Logger _logger = Logger.getLogger("de.hunsicker.jalopy.language.javadoc");
    private Set _standardTags = new HashSet();
    private Set _inlineTags = new HashSet();
    private Map _tokenTypes;
    private JavadocLexer _lexer;
    private int _startLine;
    private int _startColumn;
    public static final Node EMPTY_JAVADOC_COMMENT = new Node(6, "<JAVADOC_COMMENT>"){};
    private JavaNodeFactory _factory = null;
    private Recognizer recognizer = null;
    private static final String JAVADOC_COMMENT = "JAVADOC_COMMENT";
    static /* synthetic */ Class class$de$hunsicker$jalopy$language$JavadocLexer;

    public JavadocParser(TokenBuffer tokenBuf, JavaNodeFactory factory) {
        this(tokenBuf, 1, factory);
    }

    public JavadocParser(TokenStream lexer, JavaNodeFactory factory) {
        this(lexer, 1, factory);
    }

    public JavadocParser(ParserSharedInputState state) {
        super(state);
        this.loadTokenTypeInfo();
        this.loadTagInfo(true);
    }

    protected JavadocParser(TokenBuffer tokenBuf, int k, JavaNodeFactory factory) {
        super(tokenBuf, k);
        this.loadTokenTypeInfo();
        this.loadTagInfo(true);
        this._factory = factory;
    }

    protected JavadocParser(TokenStream lexer, int k, JavaNodeFactory factory) {
        super(lexer, k);
        this.loadTokenTypeInfo();
        this.loadTagInfo(true);
        this._factory = factory;
    }

    public void setLexer(JavadocLexer lexer) {
        this._lexer = lexer;
    }

    private void loadTokenTypeInfo() {
        try {
            Properties props = new Properties();
            props.load((class$de$hunsicker$jalopy$language$JavadocLexer == null ? (class$de$hunsicker$jalopy$language$JavadocLexer = JavadocParser.class$("de.hunsicker.jalopy.language.JavadocLexer")) : class$de$hunsicker$jalopy$language$JavadocLexer).getResourceAsStream("JavadocTokenTypes.txt"));
            this._tokenTypes = new HashMap((int)((double)props.size() * 1.3));
            this._tokenTypes.putAll(props);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed loading token types file -- JavadocTokenTypes.txt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        if (file.exists()) {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                props.load(in);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
        return props;
    }

    private void loadCustomTagInfo(File file, Set tags) {
        try {
            Properties props = this.loadProperties(file);
            tags.addAll(props.keySet());
        }
        catch (Exception ex) {
            throw new RuntimeException("failed loading tag definition file -- " + file);
        }
    }

    private void loadStandardTagInfo(boolean force) {
        if (force) {
            this._standardTags.clear();
            this._standardTags.add("@author");
            this._standardTags.add("@deprecated");
            this._standardTags.add("@exception");
            this._standardTags.add("@param");
            this._standardTags.add("@return");
            this._standardTags.add("@see");
            this._standardTags.add("@serial");
            this._standardTags.add("@serialData");
            this._standardTags.add("@serialField");
            this._standardTags.add("@since");
            this._standardTags.add("@throws");
            this._standardTags.add("@todo");
            this._standardTags.add("@version");
        }
    }

    private void loadInlineTagInfo(boolean force) {
        if (force) {
            this._inlineTags.clear();
            this._inlineTags.add("@docRoot");
            this._inlineTags.add("@inheritDoc");
            this._inlineTags.add("@link");
            this._inlineTags.add("@linkPlain");
            this._inlineTags.add("@value");
            this._inlineTags.add("@code");
            this._inlineTags.add("@literal");
        }
    }

    public void setCustomStandardTags(Collection tags) {
        this._standardTags.addAll(tags);
    }

    public void setCustomInlineTags(Collection tags) {
        this._inlineTags.addAll(tags);
    }

    private void loadTagInfo(boolean force) {
        if (force) {
            this._standardTags = new HashSet(15);
            this._inlineTags = new HashSet(8);
        }
        this.loadStandardTagInfo(force);
        this.loadInlineTagInfo(force);
    }

    protected void setTagType(AST tag, String type) {
        String text = tag.getText();
        String name = this.getTag(text, type);
        if (name == null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this._lexer.getLine()), new Integer(this._lexer.getColumn()), text};
            this._logger.l7dlog(Level.ERROR, "TAG_INVALID", args, null);
        } else {
            String t;
            if (name != text) {
                tag.setText(name);
                Object[] args = new Object[]{this.getFilename(), new Integer(this._lexer.getLine()), new Integer(this._lexer.getColumn()), text, name};
                this._logger.l7dlog(Level.WARN, "TAG_MISSPELLED_NAME", args, null);
            }
            if ((t = (String)this._tokenTypes.get(type + name.substring(1).toUpperCase())) == null) {
                if (type == "TAG_") {
                    tag.setType(13);
                } else {
                    tag.setType(26);
                }
            } else {
                try {
                    int result = Integer.parseInt(t);
                    tag.setType(result);
                }
                catch (NumberFormatException neverOccurs) {}
            }
        }
    }

    String getTag(String text, String type) {
        Set tags = null;
        tags = type == "TAG_" ? this._standardTags : this._inlineTags;
        if (tags.contains(text)) {
            return text;
        }
        Lcs lcs = new Lcs();
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            String tag = (String)i.next();
            lcs.init(text, tag);
            double similarity = lcs.getPercentage();
            if (!(similarity > 70.0)) continue;
            return tag;
        }
        return null;
    }

    public void reset() {
        if (this.inputState != null) {
            this.inputState.reset();
        }
        this.setFilename("<unknown>");
        this.returnAST = null;
    }

    public AST getParseTree() {
        if (this.returnAST == null) {
            return EMPTY_JAVADOC_COMMENT;
        }
        Node current = (Node)this.returnAST;
        JavaNode root = this._factory.create(this._startLine, this._startColumn, current.endLine, current.endColumn);
        root.setType(6);
        root.setText(JAVADOC_COMMENT);
        root.setFirstChild(this.returnAST);
        return root;
    }

    public void reportError(RecognitionException ex) {
        Integer line = new Integer((this.recognizer != null ? this.recognizer.getStartLine() : 0) + ex.getLine());
        Integer column = new Integer((this.recognizer != null ? this.recognizer.getStartColumn() : 0) + ex.getColumn());
        Object[] args = new Object[]{this.getFilename(), line, column, ex.getMessage()};
        this._logger.l7dlog(Level.ERROR, "PARSER_ERROR", args, ex);
    }

    public void reportError(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this._lexer.getLine()), new Integer(this._lexer.getColumn()), message};
        this._logger.l7dlog(Level.ERROR, "PARSER_ERROR", args, null);
    }

    public void reportWarning(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this._lexer.getLine()), new Integer(this._lexer.getColumn()), message};
        this._logger.l7dlog(Level.WARN, message, args, null);
    }

    public void handleRecoverableError(RecognitionException ex) {
        if (ex instanceof MismatchedTokenException) {
            MismatchedTokenException mtex = (MismatchedTokenException)ex;
            if (mtex.token != null) {
                switch (mtex.expecting) {
                    case 58: {
                        System.err.println("[WARN] ambigious missing </p> tag around line " + mtex.token.getLine() + " ");
                        ASTPair currentAST = new ASTPair();
                        AST tmp2_AST = this.astFactory.create(mtex.token);
                        this.astFactory.makeASTRoot(currentAST, tmp2_AST);
                        this.astFactory.addASTChild(currentAST, this.returnAST);
                        this._lexer.setLine(this._lexer.getLine() + 1);
                        break;
                    }
                    default: {
                        this.reportError(ex);
                        break;
                    }
                }
            } else {
                this.reportError(ex);
            }
        } else {
            this.reportError(ex);
        }
    }

    public void parse() throws RecognitionException, TokenStreamException {
        if (this.inputState.guessing == 0) {
            this._startLine = this._lexer.getLine();
            this._startColumn = this._lexer.getColumn();
        }
        this.internalParse();
    }

    public void setRecognizer(Recognizer recognizer2) {
        this.recognizer = recognizer2;
        this._lexer.setRecognizer(recognizer2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

