/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.Annotation;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.ImportTransformation;
import de.hunsicker.jalopy.language.JavaParser;
import de.hunsicker.jalopy.language.LoggerTransformation;
import de.hunsicker.jalopy.language.Position;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.SerializableTransformation;
import de.hunsicker.jalopy.language.SortTransformation;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaLexer;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavadocParser;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;

public final class JavaRecognizer
extends Recognizer {
    private static final String DELIMETER = "|";
    public static final int JDK_1_3 = 13;
    public static final int JDK_1_4 = 14;
    private Convention _settings;
    List _annotations = Collections.EMPTY_LIST;
    Position _position;
    private Transformation _importTrans;
    private Transformation _loggingTransformation;
    private Transformation _serialTrans;
    private Transformation _sortTrans;
    boolean _trackPosition;
    private boolean _transformed;
    protected AST root = null;

    public JavaRecognizer(CompositeFactory factory) {
        this._settings = Convention.getInstance();
        JavaLexer l = new JavaLexer(factory);
        this.lexer = l;
        JavaParser p = (JavaParser)l.getParser();
        this.parser = p;
        this._importTrans = new ImportTransformation(p.getQualifiedIdents(), p.getUnqualifiedIdents(), factory.getJavaNodeFactory());
        this._sortTrans = new SortTransformation(factory);
        this._serialTrans = new SerializableTransformation(factory);
        this._loggingTransformation = new LoggerTransformation(factory.getJavaNodeFactory());
    }

    public String getPackageName() {
        if (!this.finished) {
            throw new IllegalStateException("parser not started or still running");
        }
        return ((JavaParser)this.parser).getPackageName();
    }

    public AST getParseTree() {
        if (!this.finished) {
            throw new IllegalStateException("parser not started or still running");
        }
        if (!this._transformed) {
            boolean trackAnnotations;
            boolean bl = trackAnnotations = !this._annotations.isEmpty();
            if (this._trackPosition || trackAnnotations) {
                PositionTracker tracker = new PositionTracker();
                if (trackAnnotations) {
                    tracker.annotation = (Annotation)this._annotations.get(0);
                }
                tracker.walk(super.getParseTree());
            }
            this.transform();
            this._transformed = true;
        }
        return super.getParseTree();
    }

    public void setPosition(int line, int column) {
        if (line < 1) {
            throw new IllegalArgumentException("line < 1 -- " + line);
        }
        if (column < 1) {
            throw new IllegalArgumentException("column < 1 -- " + column);
        }
        this._trackPosition = true;
        this._position = new Position(line, column);
    }

    public Position getPosition() {
        return this._position;
    }

    public void attachAnnotations(List annotations) {
        this._annotations = annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List detachAnnotations() {
        try {
            List list = this._annotations;
            Object var3_2 = null;
            if (this._annotations != Collections.EMPTY_LIST) {
                this._annotations = Collections.EMPTY_LIST;
            }
            return list;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_3 = null;
                if (this._annotations == Collections.EMPTY_LIST) break block3;
                this._annotations = Collections.EMPTY_LIST;
            }
            throw throwable;
        }
    }

    public boolean hasAnnotations() {
        return !this._annotations.isEmpty();
    }

    public boolean hasPosition() {
        return this._position != null;
    }

    public void parse(Reader in, String filename) {
        if (this.running) {
            throw new IllegalStateException("parser currently running");
        }
        this.finished = false;
        this.running = true;
        this._transformed = false;
        JavaParser javaParser = (JavaParser)this.parser;
        javaParser.stripQualification = this._settings.getBoolean(ConventionKeys.STRIP_QUALIFICATION, false);
        JavaLexer javaLexer = (JavaLexer)this.lexer;
        javaLexer.setTabSize(this._settings.getInt(ConventionKeys.INDENT_SIZE_TABS, 8));
        javaLexer.sourceVersion = this._settings.getInt(ConventionKeys.SOURCE_VERSION, 15);
        javaLexer.parseJavadocComments = this._settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false);
        javaLexer.removeJavadocComments = this._settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_REMOVE, false);
        javaLexer.removeSLComments = this._settings.getBoolean(ConventionKeys.COMMENT_REMOVE_SINGLE_LINE, false);
        javaLexer.removeMLComments = this._settings.getBoolean(ConventionKeys.COMMENT_REMOVE_MULTI_LINE, false);
        javaLexer.formatMLComments = this._settings.getBoolean(ConventionKeys.COMMENT_FORMAT_MULTI_LINE, false);
        JavadocParser javadocParser = javaLexer.getJavadocParser();
        javadocParser.setCustomStandardTags(this.decodeTags(this._settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_STANDARD, ConventionDefaults.COMMENT_JAVADOC_TAGS_STANDARD)));
        javadocParser.setCustomInlineTags(this.decodeTags(this._settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_INLINE, ConventionDefaults.COMMENT_JAVADOC_TAGS_INLINE)));
        this.lexer.setInputBuffer(in);
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter(this.lexer){
            protected boolean attachBefore;
            {
                this.attachBefore = false;
            }

            private void consumeFirst() throws TokenStreamException {
                do {
                    this.consume();
                } while (this.LA(1).getType() == -1);
                ExtendedToken p = null;
                while (this.hideMask.member(this.LA(1).getType()) || this.discardMask.member(this.LA(1).getType())) {
                    if (this.hideMask.member(this.LA(1).getType())) {
                        if (p == null) {
                            p = (ExtendedToken)this.LA(1);
                        } else {
                            p.setHiddenAfter(this.LA(1));
                            ((ExtendedToken)this.LA(1)).setHiddenBefore(p);
                            p = (ExtendedToken)this.LA(1);
                        }
                        this.lastHiddenToken = p;
                        if (this.firstHidden == null) {
                            this.firstHidden = p;
                        }
                    }
                    do {
                        this.consume();
                    } while (this.LA(1).getType() == -1);
                }
            }

            public Token nextToken() throws TokenStreamException {
                if (this.LA(1) == null) {
                    this.consumeFirst();
                }
                ExtendedToken monitored = (ExtendedToken)this.LA(1);
                if (this.lastHiddenToken != null && !((ExtendedToken)this.lastHiddenToken).attached) {
                    monitored.setHiddenBefore(this.lastHiddenToken);
                } else {
                    monitored.setHiddenBefore(null);
                }
                this.lastHiddenToken = null;
                do {
                    this.consume();
                } while (this.LA(1).getType() == -1);
                ExtendedToken p = monitored;
                ExtendedToken next = (ExtendedToken)this.LA(1);
                this.attachBefore = false;
                while (this.hideMask.member(next.getType()) || this.discardMask.member(next.getType())) {
                    if (this.hideMask.member(next.getType())) {
                        if (!this.attachBefore && !next.attached && next.getType() != 6) {
                            p.setHiddenAfter(next);
                            if (p == monitored) {
                                next.attached = true;
                            }
                            next.setHiddenBefore(p);
                            if (p != monitored && this.lastHiddenToken == null) {
                                this.lastHiddenToken = p;
                            }
                        }
                        if (p != monitored && this.attachBefore && !p.attached) {
                            next.setHiddenBefore(p);
                            p.setHiddenAfter(next);
                            p.attached = true;
                            this.lastHiddenToken = next;
                        }
                        if (this.lastHiddenToken == null && !next.attached) {
                            this.lastHiddenToken = next;
                        }
                        p = next;
                    } else if (next.getType() == 175 && next.getText().indexOf("\n") > -1) {
                        monitored.nlAfter = new StringTokenizer(next.getText(), "\n").countTokens();
                        if (monitored.nlAfter > 4) {
                            int x = 2;
                            ++x;
                            System.out.println(monitored);
                        }
                        if (!this.attachBefore) {
                            this.attachBefore = true;
                            if (this.lastHiddenToken != null && ((ExtendedToken)this.lastHiddenToken).attached) {
                                this.lastHiddenToken = null;
                            }
                        }
                    }
                    do {
                        this.consume();
                    } while ((next = (ExtendedToken)this.LA(1)).getType() == -1);
                }
                return monitored;
            }
        };
        filter.discard(175);
        filter.discard(69);
        if (javaLexer.removeJavadocComments) {
            filter.discard(6);
        } else {
            filter.hide(6);
        }
        if (javaLexer.removeMLComments) {
            filter.discard(178);
        } else {
            filter.hide(178);
        }
        filter.hide(72);
        if (javaLexer.removeSLComments) {
            filter.discard(176);
        } else {
            filter.hide(176);
        }
        this.lexer.setFilename(filename);
        this.parser.setFilename(filename);
        this.parser.setTokenBuffer(new TokenBuffer(filter));
        try {
            try {
                this.parser.parse();
                this.root = ((JavaParser)this.parser).getAST();
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
                throw new Recognizer.ParseException(ex);
            }
            catch (TokenStreamRecognitionException ex) {
                ex.printStackTrace();
                throw new Recognizer.ParseException(ex);
            }
            catch (TokenStreamException ex) {
                ex.printStackTrace();
                throw new Recognizer.ParseException(ex);
            }
            Object var11_7 = null;
            this.finished = true;
            this.running = false;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.finished = true;
            this.running = false;
            throw throwable;
        }
    }

    public AST getRoot() {
        return this.root;
    }

    private Collection decodeTags(String tags) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer i = new StringTokenizer(tags, DELIMETER);
        while (i.hasMoreElements()) {
            result.add(i.nextToken());
        }
        return result;
    }

    private void transform() {
        block5: {
            AST tree = this.parser.getParseTree();
            if (tree == null) break block5;
            try {
                this._importTrans.apply(tree);
                if (this._settings.getBoolean(ConventionKeys.INSERT_SERIAL_UID, false)) {
                    this._serialTrans.apply(tree);
                }
                if (this._settings.getBoolean(ConventionKeys.SORT, true)) {
                    this._sortTrans.apply(tree);
                }
                if (this._settings.getBoolean(ConventionKeys.INSERT_LOGGING_CONDITIONAL, false)) {
                    this._loggingTransformation.apply(tree);
                }
            }
            catch (TransformationException ex) {
                Object[] args = new Object[]{this.parser.getFilename()};
                Loggers.IO.l7dlog(Level.ERROR, "TRANS_ERROR", args, ex);
            }
        }
    }

    private final class PositionTracker
    extends TreeWalker {
        Annotation annotation;
        int index;

        private PositionTracker() {
        }

        public void visit(AST node) {
            switch (node.getType()) {
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 47: 
                case 48: 
                case 68: 
                case 77: 
                case 78: 
                case 80: 
                case 81: 
                case 84: 
                case 86: 
                case 87: 
                case 88: 
                case 108: 
                case 109: 
                case 110: 
                case 114: 
                case 120: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 168: {
                    return;
                }
            }
            JavaNode n = (JavaNode)node;
            if (this.annotation != null && n.getStartLine() == this.annotation.getLine()) {
                n.attachAnnotation(this.annotation);
                ++this.index;
                if (JavaRecognizer.this._annotations.size() > this.index) {
                    this.annotation = (Annotation)JavaRecognizer.this._annotations.get(this.index);
                } else {
                    this.annotation = null;
                    if (!JavaRecognizer.this._trackPosition) {
                        this.stop();
                    }
                }
            }
            if (JavaRecognizer.this._trackPosition) {
                int line = n.getStartLine();
                if (line == JavaRecognizer.this._position.line) {
                    n.setPosition(JavaRecognizer.this._position);
                    JavaRecognizer.this._trackPosition = false;
                    if (this.annotation == null) {
                        this.stop();
                    }
                } else if (line > JavaRecognizer.this._position.line) {
                    n.setPosition(JavaRecognizer.this._position);
                    JavaRecognizer.this._trackPosition = false;
                    if (this.annotation == null) {
                        this.stop();
                    }
                }
            }
        }
    }
}

