/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.combination.multi;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.combination.multi.MultiCombinationGenerator;

public class MultiCombinationIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final MultiCombinationGenerator<T> _generator;
    protected ICombinatoricsVector<T> _currentCombination = null;
    protected long _currentIndex = 0L;
    protected final int _lengthN;
    protected final int _lengthK;
    private int[] _bitVector = null;
    private boolean _end = false;

    public MultiCombinationIterator(MultiCombinationGenerator<T> multiCombinationGenerator) {
        this._generator = multiCombinationGenerator;
        this._lengthN = multiCombinationGenerator.getOriginalVector().getSize();
        this._currentCombination = Factory.createVector();
        this._bitVector = new int[multiCombinationGenerator.getCombinationLength()];
        this._lengthK = multiCombinationGenerator.getCombinationLength() - 1;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this._generator.getCombinationLength(); ++i) {
            this._bitVector[i] = 0;
        }
        this._end = false;
        this._currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return !this._end;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        int n;
        int n2;
        ++this._currentIndex;
        for (n2 = 0; n2 < this._generator.getCombinationLength(); ++n2) {
            n = this._bitVector[n2];
            if (this._generator.getOriginalVector().getSize() <= 0) continue;
            this._currentCombination.setValue(n2, this._generator.getOriginalVector().getValue(n));
        }
        if (this._bitVector.length > 0) {
            int n3 = this._lengthK;
            this._bitVector[n3] = this._bitVector[n3] + 1;
            if (this._bitVector[this._lengthK] > this._lengthN - 1) {
                n2 = -1;
                for (n = 1; n <= this._bitVector.length; ++n) {
                    if (this._lengthK - n < 0 || this._bitVector[this._lengthK - n] >= this._lengthN - 1) continue;
                    n2 = this._lengthK - n;
                    break;
                }
                if (n2 != -1) {
                    int n4 = n2;
                    this._bitVector[n4] = this._bitVector[n4] + 1;
                    for (n = 1; n < this._bitVector.length - n2; ++n) {
                        this._bitVector[n2 + n] = this._bitVector[n2];
                    }
                } else {
                    this._end = true;
                }
            }
        } else {
            this._end = true;
        }
        return Factory.createVector(this._currentCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "MultiCombinationIterator=[#" + this._currentIndex + ", " + this._currentCombination + "]";
    }
}

