/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics.ICombinatoricsVector;

public class CombinatoricsVector<T>
implements ICombinatoricsVector<T> {
    protected final List<T> _vector;

    public CombinatoricsVector() {
        this._vector = new ArrayList<T>();
    }

    public CombinatoricsVector(Collection<? extends T> collection) {
        this._vector = new ArrayList<T>(collection.size());
        this._vector.addAll(collection);
    }

    public CombinatoricsVector(T[] TArray) {
        this._vector = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            this._vector.add(TArray[i]);
        }
    }

    public CombinatoricsVector(ICombinatoricsVector<T> iCombinatoricsVector) {
        this._vector = new ArrayList<T>(iCombinatoricsVector.getSize());
        this._vector.addAll(iCombinatoricsVector.getVector());
    }

    @Override
    public void setValue(int n, T t) {
        try {
            this._vector.set(n, t);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this._vector.add(n, t);
        }
    }

    @Override
    public boolean addValue(T t) {
        return this._vector.add(t);
    }

    @Override
    public T getValue(int n) {
        return this._vector.get(n);
    }

    @Override
    public int getSize() {
        if (this._vector == null) {
            return 0;
        }
        return this._vector.size();
    }

    @Override
    public boolean hasDuplicates() {
        if (this._vector.size() <= 1) {
            return false;
        }
        HashSet<T> hashSet = new HashSet<T>(this._vector);
        return hashSet.size() < this._vector.size();
    }

    @Override
    public int countElements(T t) {
        if (this._vector.size() == 0) {
            return 0;
        }
        int n = 0;
        for (T t2 : this._vector) {
            if (!t2.equals(t)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean contains(T t) {
        return this._vector.contains(t);
    }

    @Override
    public boolean isAllElementsEqual() {
        if (this._vector.size() == 0) {
            return false;
        }
        if (this._vector.size() == 1) {
            return true;
        }
        HashSet<T> hashSet = new HashSet<T>(this._vector);
        return hashSet.size() == 1;
    }

    @Override
    public List<T> getVector() {
        return this._vector;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._vector == null ? 0 : this._vector.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CombinatoricsVector combinatoricsVector = (CombinatoricsVector)object;
        return !(this._vector == null ? combinatoricsVector._vector != null : !this._vector.equals(combinatoricsVector._vector));
    }

    @Override
    public void clearVector() {
        this._vector.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this._vector.iterator();
    }

    public String toString() {
        return "CombinatoricsVector=(" + this._vector + ", size=" + this.getSize() + ")";
    }
}

