/*
 * Decompiled with CFR 0.152.
 */
package system.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SymbolTable {
    private static boolean debug = false;
    private static SymbolTable instance;
    private static SymbolTable current;
    private SymbolTable parent;
    private final String name;
    private List<SymbolTable> members = new ArrayList<SymbolTable>();
    private List<SymbolTable> inherited = new ArrayList<SymbolTable>();
    private HashMap<String, SymbolTable> bindings = new HashMap();
    private final Properties properties = new Properties();

    public static SymbolTable root() {
        return instance;
    }

    public static SymbolTable instance() {
        return current;
    }

    public static void debug(boolean d) {
        debug = d;
    }

    public static SymbolTable current() {
        return current;
    }

    public static void enter() {
        SymbolTable next;
        current = next = current.declareBlock();
        if (debug) {
            System.out.println("Enter " + next.toQualifiedString());
        }
    }

    public static void enter(SymbolTable next) {
        if (next == null) {
            throw new IllegalArgumentException("SymbolTable should never be null!");
        }
        if (next.parent != current) {
            throw new IllegalArgumentException("SymbolTable not declared in parent scope!\nnext.Parent " + next.parent.toQualifiedString() + "\ncurrent " + current.toQualifiedString());
        }
        next.parent = current;
        current = next;
        if (debug) {
            System.out.println("Enter " + next.toQualifiedString());
        }
    }

    public static void exit() {
        SymbolTable previous = current;
        if (debug) {
            System.out.println("Exit " + previous.toQualifiedString());
        }
        if (debug) {
            System.out.println(SymbolTable.inspect(previous));
        }
        if (previous.isGlobal()) {
            return;
        }
        current = previous.parent;
    }

    private static void inspect(StringBuilder b, SymbolTable s) {
        b.append(s.toString());
        if (!s.members.isEmpty()) {
            b.append("{");
        }
        b.append("\n");
        for (SymbolTable n : s.members) {
            SymbolTable.inspect(b, n);
        }
        if (!s.members.isEmpty()) {
            b.append("}\n");
        }
    }

    public static String inspect(SymbolTable s) {
        StringBuilder b = new StringBuilder();
        SymbolTable.inspect(b, s);
        return b.toString();
    }

    public static String inspect() {
        StringBuilder b = new StringBuilder();
        SymbolTable.inspect(b, instance);
        return b.toString();
    }

    public static void clear() {
        current = instance = new SymbolTable();
        if (debug) {
            System.out.println("SymbolTable reintialized (cleared)!");
        }
    }

    private SymbolTable() {
        this.parent = null;
        this.name = "GlobalScope";
    }

    protected SymbolTable(String name, SymbolTable parent) {
        if (name == null || parent == null) {
            throw new IllegalArgumentException("Neither Name nor Parent scope should be null!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name should not be empty!");
        }
        this.name = name;
        this.parent = parent;
    }

    protected SymbolTable(SymbolTable parent) {
        this("LocalScope", parent);
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public String getName() {
        return this.name;
    }

    public SymbolTable declareBlock() {
        SymbolTable b = new SymbolTable(this);
        b.properties().put("kind", "block");
        this.members.add(b);
        if (debug) {
            System.out.println("Declare Block " + b.toQualifiedString() + " into " + this.toQualifiedString());
        }
        return b;
    }

    public SymbolTable declareSymbol(String name) {
        SymbolTable b = new SymbolTable(name, this);
        b.properties().put("kind", "symbol");
        this.members.add(b);
        this.bindings.put(name, b);
        if (debug) {
            System.out.println("Declare Symbol " + b.toQualifiedString() + " into " + this.toQualifiedString());
        }
        return b;
    }

    public SymbolTable declareMethod(String name) {
        SymbolTable b = new SymbolTable(name, this);
        b.properties().put("kind", "method");
        this.members.add(b);
        this.bindings.put(name, b);
        if (debug) {
            System.out.println("Declare Method " + b.toQualifiedString() + " into " + this.toQualifiedString());
        }
        return b;
    }

    public SymbolTable declareSymbol(String name, HashMap<String, String> properties) {
        SymbolTable b = new SymbolTable(name, this);
        b.properties().put("kind", "symbol");
        if (properties != null) {
            b.properties().putAll(properties);
        }
        this.members.add(b);
        this.bindings.put(name, b);
        if (debug) {
            System.out.println("Declare Symbol " + b.toQualifiedString() + " into " + this.toQualifiedString());
        }
        return b;
    }

    public SymbolTable declareClass(String name, SymbolTable ... inherited) {
        SymbolTable b = new SymbolTable(name, this);
        b.properties().put("kind", "class");
        this.members.add(b);
        this.bindings.put(name, b);
        for (SymbolTable i : inherited) {
            if (i == null) continue;
            b.inherited.add(i);
        }
        if (debug) {
            System.out.println("Declare Class " + b.toQualifiedString());
        }
        return b;
    }

    public SymbolTable getParent() {
        return this.parent;
    }

    public boolean addSuperClass(SymbolTable superClass) {
        if (superClass == null) {
            throw new IllegalArgumentException("Neither superClass nor properties should never be null!");
        }
        if (debug) {
            System.out.println("Add Super Class " + superClass.toQualifiedString());
        }
        return this.inherited.add(superClass);
    }

    public List<SymbolTable> superClasses() {
        return Collections.unmodifiableList(this.inherited);
    }

    public SymbolTable resolveClassMember(String name, Map<String, String> properties) {
        SymbolTable b;
        if (name == null || properties == null) {
            throw new IllegalArgumentException("Neither name nor properties should be null!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name should not be empty!");
        }
        if (this.bindings.containsKey(name) && (b = this.bindings.get(name)).properties().fulfills(properties)) {
            return b;
        }
        for (SymbolTable s : this.inherited) {
            SymbolTable b2;
            if (!s.bindings.containsKey(name) || !(b2 = s.bindings.get(name)).properties().fulfills(properties)) continue;
            return b2;
        }
        for (SymbolTable s : this.inherited) {
            SymbolTable result = s.resolveClassMember(name, properties);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public SymbolTable resolve(String name, Map<String, String> properties) {
        if (name == null || properties == null) {
            throw new IllegalArgumentException("Neither name nor properties should be null!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name should not be empty!");
        }
        SymbolTable result = this.resolveClassMember(name, properties);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.resolve(name, properties);
        }
        return null;
    }

    public SymbolTable resolveClassMember(String name) {
        return this.resolveClassMember(name, Collections.emptyMap());
    }

    public SymbolTable resolve(String name) {
        return this.resolve(name, Collections.emptyMap());
    }

    public Properties properties() {
        return this.properties;
    }

    public String toString() {
        return this.name;
    }

    public String toQualifiedString() {
        return this.parent != null ? this.parent.toQualifiedString() + "." + this.name : this.name;
    }

    static {
        current = instance = new SymbolTable();
    }

    public class Properties {
        private HashMap<String, String> properties = new HashMap();

        public void put(String property, String value) {
            if (property == null || value == null) {
                throw new IllegalArgumentException("Neither property nor value should be null!");
            }
            if (property.isEmpty()) {
                throw new IllegalArgumentException("Property should not be an empty string!");
            }
            this.properties.put(property, value);
        }

        public boolean has(String property) {
            if (property == null || property.isEmpty()) {
                throw new IllegalArgumentException("Property should never be null or empty!");
            }
            return this.properties.containsKey(property);
        }

        public String get(String property) {
            if (!this.has(property)) {
                return null;
            }
            return this.properties.get(property);
        }

        public void putAll(Map<String, String> properties) {
            if (properties != null) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    if (e.getKey() == null || e.getValue() == null || e.getKey().isEmpty()) continue;
                    this.put(e.getKey(), e.getValue());
                }
            }
        }

        public boolean fulfills(Map<String, String> properties) {
            if (properties == null) {
                throw new IllegalArgumentException("properties should never be null!");
            }
            for (Map.Entry<String, String> e : properties.entrySet()) {
                String s = this.get(e.getKey());
                if (s == null) {
                    return false;
                }
                if (s.equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public SymbolTable bearer() {
            return SymbolTable.this;
        }
    }
}

