/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.subsets;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.subsets.SubListIterator;
import org.paukov.combinatorics.subsets.SubSetIterator;
import org.paukov.combinatorics.util.Util;

public class SubSetGenerator<T>
extends Generator<T> {
    protected final boolean _hasDuplicates;
    protected final boolean _treatAsIdentical;
    protected final ICombinatoricsVector<T> _originalVector;

    public SubSetGenerator(ICombinatoricsVector<T> iCombinatoricsVector) {
        this._hasDuplicates = iCombinatoricsVector.hasDuplicates();
        this._treatAsIdentical = true;
        this._originalVector = Factory.createVector(iCombinatoricsVector);
    }

    public SubSetGenerator(ICombinatoricsVector<T> iCombinatoricsVector, boolean bl) {
        this._hasDuplicates = iCombinatoricsVector.hasDuplicates();
        this._treatAsIdentical = bl;
        this._originalVector = Factory.createVector(iCombinatoricsVector);
    }

    @Override
    public ICombinatoricsVector<T> getOriginalVector() {
        return this._originalVector;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        if (this.isSubList()) {
            throw new RuntimeException("The initial vector has duplicates: " + this._originalVector);
        }
        return Util.pow2(this._originalVector.getSize());
    }

    @Override
    public Iterator<ICombinatoricsVector<T>> iterator() {
        if (this.isSubList()) {
            return new SubListIterator(this);
        }
        return new SubSetIterator(this);
    }

    protected boolean isSubList() {
        return this._treatAsIdentical && this._hasDuplicates;
    }
}

