/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.permutations;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.permutations.PermutationWithRepetitionIterator;

public class PermutationWithRepetitionGenerator<T>
extends Generator<T> {
    protected final ICombinatoricsVector<T> _originalVector;
    protected final int _permutationLength;

    public PermutationWithRepetitionGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        this._originalVector = Factory.createVector(iCombinatoricsVector);
        this._permutationLength = n;
    }

    @Override
    public Iterator<ICombinatoricsVector<T>> iterator() {
        return new PermutationWithRepetitionIterator(this);
    }

    @Override
    public ICombinatoricsVector<T> getOriginalVector() {
        return this._originalVector;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        return (long)Math.pow(this._originalVector.getSize(), this._permutationLength);
    }

    public int getPermutationLength() {
        return this._permutationLength;
    }
}

