/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.permutations;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;

public class DuplicatedPermutationIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final Generator<T> _generator;
    protected ICombinatoricsVector<T> _currentPermutation;
    protected long _currentIndex = 0L;
    protected final int _length;
    private int[] _data = null;
    private boolean _firstIteration = true;
    protected ICombinatoricsVector<T> _initialOrderedPermutation;

    public DuplicatedPermutationIterator(Generator<T> generator) {
        this._generator = generator;
        this._length = ((ICombinatoricsVector)generator.getOriginalVector()).getSize();
        this._data = new int[this._length];
        ICombinatoricsVector iCombinatoricsVector = (ICombinatoricsVector)generator.getOriginalVector();
        ICombinatoricsVector<T> iCombinatoricsVector2 = Factory.createVector();
        LinkedHashSet linkedHashSet = new LinkedHashSet(iCombinatoricsVector.getVector());
        linkedHashSet.addAll(iCombinatoricsVector.getVector());
        int n = 0;
        int n2 = 0;
        this._initialOrderedPermutation = Factory.createVector(linkedHashSet);
        for (int i = 0; i < this._initialOrderedPermutation.getSize(); ++i) {
            T t = this._initialOrderedPermutation.getValue(i);
            ++n;
            if (iCombinatoricsVector2.contains(t)) continue;
            int n3 = iCombinatoricsVector.countElements(t);
            for (int j = 0; j < n3; ++j) {
                this._data[n2++] = n;
                iCombinatoricsVector2.addValue(t);
            }
        }
        this.init();
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private boolean isFinished() {
        int n = this._data.length - 2;
        while (this._data[n] >= this._data[n + 1]) {
            if (--n >= 0) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this._currentIndex = 0L;
        this._currentPermutation = Factory.createVector();
        for (int i = 0; i < this._length; ++i) {
            int n = this._data[i] - 1;
            this._currentPermutation.addValue(this._initialOrderedPermutation.getValue(n));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished() || this._firstIteration;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        int n;
        if (this._firstIteration) {
            this._firstIteration = false;
            return this._currentPermutation;
        }
        int n2 = this._data.length - 2;
        while (this._data[n2] >= this._data[n2 + 1]) {
            --n2;
        }
        int n3 = this._data.length - 1;
        while (this._data[n2] >= this._data[n3]) {
            --n3;
        }
        DuplicatedPermutationIterator.swap(this._data, n2, n3);
        int n4 = this._data.length - (n2 + 1);
        for (n = 0; n < n4 / 2; ++n) {
            DuplicatedPermutationIterator.swap(this._data, n2 + 1 + n, this._data.length - n - 1);
        }
        ++this._currentIndex;
        this._currentPermutation = Factory.createVector();
        for (n = 0; n < this._length; ++n) {
            int n5 = this._data[n] - 1;
            this._currentPermutation.addValue(this._initialOrderedPermutation.getValue(n5));
        }
        return this._currentPermutation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "DuplicatedPermutationIterator=[#" + this._currentIndex + ", " + this._currentPermutation + "]";
    }
}

