/*
 * Decompiled with CFR 0.152.
 */
package neverlang.utils.debug;

import dexter.grammar.Grammar;
import java.util.ArrayList;
import java.util.Arrays;
import neverlang.runtime.Context;
import neverlang.runtime.SemanticAction;
import neverlang.runtime.dexter.ASTNode;
import neverlang.utils.Tuple;

public class GraphvizAST {
    ASTNode root;

    public GraphvizAST(ASTNode root) {
        this.root = root;
    }

    public String toString() {
        return String.format("digraph ParseTree { node[shape=record]; %s }", this.toString(this.root));
    }

    protected String toString(ASTNode _n) {
        String node = "n%d [label=\"{\u27e8 %s \u27e9 %s }\"];\n";
        String leaf = "n%d [label=\"'%s' | (%d:%d) \"];\n";
        String edge = "n%d -> n%d;\n";
        String nodes = "";
        ArrayList<ASTNode> queue = new ArrayList<ASTNode>();
        queue.add(_n);
        while (!queue.isEmpty()) {
            ASTNode n = (ASTNode)queue.remove(0);
            if (n.children == null || n.children.length == 0) {
                nodes = nodes + (n.getSymbol() == Grammar.EPSILON ? String.format("n%d [label=\"'%s' | (%d:%d) \"];\n", n.getId(), Grammar.EPSILON.toString(), -1, -1) : String.format("n%d [label=\"'%s' | (%d:%d) \"];\n", n.getId(), this.escape(n.token.text), n.token.row, n.token.col));
                continue;
            }
            Tuple<SemanticAction, Context> defaultAction = n.getDefaultAction(0);
            StringBuilder sb = new StringBuilder();
            for (String key : n.getValues().keySet()) {
                Object obj = n.getValue(key);
                String typ = obj == null ? "null" : obj.getClass().getSimpleName();
                sb.append(key);
                sb.append(":" + typ);
                sb.append(", ");
            }
            nodes = nodes + String.format("n%d [label=\"{\u27e8 %s \u27e9 %s }\"];\n", n.getId(), n.getSymbol().toString(), " | " + sb.toString(), " | ");
            if (null == n.children()) continue;
            queue.addAll(Arrays.asList(n.children()));
            int i = 1;
            for (ASTNode nx : n.children()) {
                nodes = nodes + String.format("n%d -> n%d;\n", n.getId(), nx.getId());
                ++i;
            }
        }
        return nodes;
    }

    protected String escape(String text) {
        return text.replace("\"", "\\\"").replace("{", "\\{").replace("}", "\\}").replace("<", "\\<").replace(">", "\\>");
    }
}

